
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_laura = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Laura")
hours_bobby = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bobby")
hours_dale = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Dale")
hours_george = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")

# Objective function
m.setObjective(4*hours_laura + 3*hours_bobby + 7*hours_dale + 5*hours_george, GRB.MINIMIZE)

# Constraints
# Minimum total dollar cost per hour for Bobby and George
m.addConstr(2*hours_bobby + 3*hours_george >= 9, name="min_cost_bobby_george")

# Minimum total dollar cost per hour for Dale and George
m.addConstr(5*hours_dale + 3*hours_george >= 13, name="min_cost_dale_george")

# Minimum total dollar cost per hour for all workers
m.addConstr(6*hours_laura + 2*hours_bobby + 5*hours_dale + 3*hours_george >= 13, name="min_cost_all")

# Constraint: 10 times hours worked by Dale minus 2 times hours worked by George >= 0
m.addConstr(10*hours_dale - 2*hours_george >= 0, name="dale_george_constraint")

# Constraint: 4 times hours worked by Laura minus hours worked by Dale >= 0
m.addConstr(4*hours_laura - hours_dale >= 0, name="laura_dale_constraint")

# Maximum total dollar cost per hour for Laura, Bobby, and Dale
m.addConstr(6*hours_laura + 2*hours_bobby + 5*hours_dale <= 44, name="max_cost_laura_bobby_dale")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {hours_laura.x}")
    print(f"Hours worked by Bobby: {hours_bobby.x}")
    print(f"Hours worked by Dale: {hours_dale.x}")
    print(f"Hours worked by George: {hours_george.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
