
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Laura", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="hours_worked_by_Bobby", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Dale", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="hours_worked_by_George", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(4*x0 + 3*x1 + 7*x2 + 5*x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(2*x1 + 3*x3 >= 9, name="constraint_1")
m.addConstr(5*x2 + 3*x3 >= 13, name="constraint_2")
m.addConstr(6*x0 + 2*x1 + 5*x2 + 3*x3 >= 13, name="constraint_3")
m.addConstr(10*x2 - 2*x3 >= 0, name="constraint_4")
m.addConstr(4*x0 - x2 >= 0, name="constraint_5")
m.addConstr(6*x0 + 2*x1 + 5*x2 <= 44, name="constraint_6")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Laura: {x0.varValue}")
    print(f"Hours worked by Bobby: {x1.varValue}")
    print(f"Hours worked by Dale: {x2.varValue}")
    print(f"Hours worked by George: {x3.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("The model is infeasible.")
