
from gurobipy import Model, GRB

# Define the model
model = Model("Food Optimization")

# Define the variables
foods = ['eggs', 'ham sandwiches', 'protein bars', 'fruit salads', 'milkshakes', 'apple pies', 'chicken breasts', 'oreos', 'chicken drumsticks']
x = model.addVars(foods, lb=0.0, name=foods)

# Define the objective function
objective = 5*x['eggs'] + 1*x['ham sandwiches'] + 2*x['protein bars'] + 1*x['fruit salads'] + 7*x['milkshakes'] + 2*x['apple pies'] + 5*x['chicken breasts'] + 5*x['oreos'] + 6*x['chicken drumsticks']
model.setObjective(objective, GRB.MINIMIZE)

# Define the resource constraints
calcium_data = {'upper_bound': 418, 'eggs': 4, 'ham sandwiches': 8, 'protein bars': 2, 'fruit salads': 8, 'milkshakes': 5, 'apple pies': 4, 'chicken breasts': 6, 'oreos': 3, 'chicken drumsticks': 3}
fiber_data = {'upper_bound': 343, 'eggs': 1, 'ham sandwiches': 3, 'protein bars': 3, 'fruit salads': 1, 'milkshakes': 10, 'apple pies': 11, 'chicken breasts': 1, 'oreos': 2, 'chicken drumsticks': 4}

model.addConstr(sum(calcium_data[f]*x[f] for f in foods) <= calcium_data['upper_bound'], "Total Calcium")
model.addConstr(sum(fiber_data[f]*x[f] for f in foods) <= fiber_data['upper_bound'], "Total Fiber")


# Define the additional constraints
model.addConstr(4*x['eggs'] + 5*x['milkshakes'] >= 18, "Calcium from eggs and milkshakes")
model.addConstr(2*x['protein bars'] + 8*x['fruit salads'] >= 33, "Calcium from protein bars and fruit salads")
model.addConstr(8*x['ham sandwiches'] + 8*x['fruit salads'] >= 28, "Calcium from ham sandwiches and fruit salads")
model.addConstr(5*x['milkshakes'] + 3*x['oreos'] >= 25, "Calcium from milkshakes and oreos")
model.addConstr(8*x['ham sandwiches'] + 6*x['chicken breasts'] >= 30, "Calcium from ham sandwiches and chicken breasts")
model.addConstr(4*x['eggs'] + 3*x['oreos'] >= 35, "Calcium from eggs and oreos")
model.addConstr(8*x['ham sandwiches'] + 2*x['protein bars'] + 5*x['milkshakes'] >= 37, "Calcium from ham sandwiches, protein bars, and milkshakes")
model.addConstr(4*x['eggs'] + 2*x['protein bars'] + 8*x['fruit salads'] >= 37, "Calcium from eggs, protein bars, and fruit salads")

# ... (Add all other calcium constraints similarly)

model.addConstr(34*x['eggs'] + 8*x['ham sandwiches'] + 2*x['protein bars'] + 8*x['fruit salads'] + 5*x['milkshakes'] + 4*x['apple pies'] + 6*x['chicken breasts'] + 3*x['oreos'] + 3*x['chicken drumsticks'] >= 34, "Total Calcium Constraint")

model.addConstr(3*x['protein bars'] + 11*x['apple pies'] >= 24, "Fiber from protein bars and apple pies")
# ... (Add all other fiber constraints similarly)

model.addConstr(x['eggs']*(-5) + x['fruit salads']*(2) >= 0, "Constraint 1")
model.addConstr(x['protein bars']*(5) + x['chicken breasts']*(-1) + x['oreos']*(-9) >= 0, "Constraint 2")
model.addConstr(x['fruit salads']*(3) + x['chicken breasts']*(-3) + x['oreos']*(5) >= 0, "Constraint 3")

# ... (Add all other constraints similarly)


# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for f in foods:
        print(f"{f}: {x[f].x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")
