
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
b12 = m.addVar(vtype=gp.GRB.INTEGER, name="B12")
iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Iron")
zinc = m.addVar(vtype=gp.GRB.INTEGER, name="Zinc")

# Set objective function
m.setObjective(4.94 * b12 + 9.67 * iron + 2.41 * zinc, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5.39 * b12 + 7.24 * zinc >= 9, "c1")
m.addConstr(5.39 * b12 + 3.4 * iron >= 13, "c2")
m.addConstr(5.39 * b12 + 3.4 * iron + 7.24 * zinc >= 13, "c3")
m.addConstr(8.08 * b12 + 5.23 * iron >= 29, "c4")
m.addConstr(8.08 * b12 + 5.23 * iron + 8.59 * zinc >= 29, "c5")
m.addConstr(10.29 * b12 + 13.7 * zinc >= 20, "c6")
m.addConstr(10.29 * b12 + 5.27 * iron >= 49, "c7")
m.addConstr(10.29 * b12 + 5.27 * iron + 13.7 * zinc >= 49, "c8")
m.addConstr(6 * b12 - 5 * iron >= 0, "c9")
m.addConstr(-3 * b12 + 3 * zinc >= 0, "c10")
m.addConstr(5.39 * b12 + 3.4 * iron <= 34, "c11")
m.addConstr(3.4 * iron + 7.24 * zinc <= 65, "c12")
m.addConstr(8.08 * b12 + 5.23 * iron <= 194, "c13")
m.addConstr(8.08 * b12 + 5.23 * iron + 8.59 * zinc <= 194, "c14")
m.addConstr(10.29 * b12 + 5.27 * iron + 13.7 * zinc <= 116, "c15")


# Resource Constraints (using the provided dictionary)
resources = {'r0': {'description': 'cognitive performance index', 'upper_bound': 72, 'x0': 5.39, 'x1': 3.4, 'x2': 7.24}, 
            'r1': {'description': 'immune support index', 'upper_bound': 209, 'x0': 8.08, 'x1': 5.23, 'x2': 8.59}, 
            'r2': {'description': 'muscle growth index', 'upper_bound': 153, 'x0': 10.29, 'x1': 5.27, 'x2': 13.7}}

for r_key, r_data in resources.items():
    m.addConstr(r_data['x0'] * b12 + r_data['x1'] * iron + r_data['x2'] * zinc <= r_data['upper_bound'], r_key)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('B12:', b12.x)
    print('Iron:', iron.x)
    print('Zinc:', zinc.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
