
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
vitamin_B12 = m.addVar(vtype=GRB.INTEGER, name="vitamin_B12")  # Whole number of milligrams
iron = m.addVar(vtype=GRB.CONTINUOUS, name="iron")  # Fractional number allowed
zinc = m.addVar(vtype=GRB.INTEGER, name="zinc")  # Non-fractional (whole) number

# Objective function: Minimize the total value
m.setObjective(4.94 * vitamin_B12 + 9.67 * iron + 2.41 * zinc, GRB.MINIMIZE)

# Constraints:
# Cognitive performance index constraints
m.addConstr(5.39 * vitamin_B12 + 7.24 * zinc >= 9, name="cognitive_min_vitamin_zinc")
m.addConstr(5.39 * vitamin_B12 + 3.4 * iron >= 13, name="cognitive_min_vitamin_iron")
m.addConstr(5.39 * vitamin_B12 + 3.4 * iron + 7.24 * zinc >= 13, name="cognitive_min_all")
m.addConstr(5.39 * vitamin_B12 + 3.4 * iron <= 34, name="cognitive_max_vitamin_iron")
m.addConstr(3.4 * iron + 7.24 * zinc <= 65, name="cognitive_max_iron_zinc")

# Immune support index constraints
m.addConstr(8.08 * vitamin_B12 + 5.23 * iron >= 29, name="immune_min_vitamin_iron")
m.addConstr(8.08 * vitamin_B12 + 5.23 * iron + 8.59 * zinc >= 29, name="immune_min_all")
m.addConstr(8.08 * vitamin_B12 + 5.23 * iron <= 194, name="immune_max_vitamin_iron")
m.addConstr(8.08 * vitamin_B12 + 5.23 * iron + 8.59 * zinc <= 194, name="immune_max_all")

# Muscle growth index constraints
m.addConstr(10.29 * vitamin_B12 + 13.7 * zinc >= 20, name="muscle_min_vitamin_zinc")
m.addConstr(10.29 * vitamin_B12 + 5.27 * iron >= 49, name="muscle_min_vitamin_iron")
m.addConstr(10.29 * vitamin_B12 + 5.27 * iron + 13.7 * zinc >= 49, name="muscle_min_all")
m.addConstr(10.29 * vitamin_B12 + 5.27 * iron + 13.7 * zinc <= 116, name="muscle_max_all")

# Specific linear inequality constraints
m.addConstr(6 * vitamin_B12 - 5 * iron >= 0, name="specific_constraint1")
m.addConstr(-3 * vitamin_B12 + 3 * zinc >= 0, name="specific_constraint2")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Vitamin B12: {vitamin_B12.x}")
    print(f"Iron: {iron.x}")
    print(f"Zinc: {zinc.x}")
else:
    print("No optimal solution found.")

