
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="vitamin_B12", vtype=gurobi.GRB.INTEGER, lb=0)  # milligrams of vitamin B12
    x1 = model.addVar(name="iron", vtype=gurobi.GRB.CONTINUOUS, lb=0)  # milligrams of iron
    x2 = model.addVar(name="zinc", vtype=gurobi.GRB.INTEGER, lb=0)  # milligrams of zinc

    # Objective function
    model.setObjective(4.94 * x0 + 9.67 * x1 + 2.41 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    # Cognitive performance index constraints
    model.addConstr(5.39 * x0 + 7.24 * x2 >= 9, name="cognitive_performance_B12_Zn")
    model.addConstr(5.39 * x0 + 3.4 * x1 >= 13, name="cognitive_performance_B12_Fe")
    model.addConstr(5.39 * x0 + 3.4 * x1 + 7.24 * x2 >= 13, name="cognitive_performance_all")
    model.addConstr(5.39 * x0 + 3.4 * x1 <= 34, name="cognitive_performance_B12_Fe_upper")
    model.addConstr(3.4 * x1 + 7.24 * x2 <= 65, name="cognitive_performance_Fe_Zn_upper")

    # Immune support index constraints
    model.addConstr(8.08 * x0 + 5.23 * x1 >= 29, name="immune_support_B12_Fe")
    model.addConstr(8.08 * x0 + 5.23 * x1 + 8.59 * x2 >= 29, name="immune_support_all")
    model.addConstr(8.08 * x0 + 5.23 * x1 <= 194, name="immune_support_B12_Fe_upper")
    model.addConstr(8.08 * x0 + 5.23 * x1 + 8.59 * x2 <= 194, name="immune_support_all_upper")

    # Muscle growth index constraints
    model.addConstr(10.29 * x0 + 13.7 * x2 >= 20, name="muscle_growth_B12_Zn")
    model.addConstr(10.29 * x0 + 5.27 * x1 >= 49, name="muscle_growth_B12_Fe")
    model.addConstr(10.29 * x0 + 5.27 * x1 + 13.7 * x2 >= 49, name="muscle_growth_all")
    model.addConstr(10.29 * x0 + 5.27 * x1 + 13.7 * x2 <= 116, name="muscle_growth_all_upper")

    # Additional constraints
    model.addConstr(6 * x0 - 5 * x1 >= 0, name="additional_constraint_1")
    model.addConstr(-3 * x0 + 3 * x2 >= 0, name="additional_constraint_2")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x0.varValue}")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Milligrams of zinc: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
