
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
bobby = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bobby")
jean = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean")
hank = model.addVar(lb=0, vtype=GRB.INTEGER, name="Hank")
george = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="George")

# Set objective function
model.setObjective(9 * bobby + 8 * jean + 2 * hank + 6 * george, GRB.MINIMIZE)

# Add constraints
model.addConstr(15 * jean + 17 * george >= 40, "c1")
model.addConstr(3 * bobby + 15 * jean + 17 * george >= 38, "c2")
model.addConstr(3 * bobby + 15 * jean + 12 * hank + 17 * george >= 38, "c3")
model.addConstr(-3 * hank + 10 * george >= 0, "c4")
model.addConstr(3 * bobby + 17 * george <= 113, "c5")
model.addConstr(3 * bobby + 12 * hank + 17 * george <= 52, "c6")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('Bobby:', bobby.x)
    print('Jean:', jean.x)
    print('Hank:', hank.x)
    print('George:', george.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', model.status)

