
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
Bobby_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")
Jean_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
Hank_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
George_hours = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_George")

# Objective function
m.setObjective(9 * Bobby_hours + 8 * Jean_hours + 2 * Hank_hours + 6 * George_hours, GRB.MINIMIZE)

# Constraints
m.addConstr(15 * Jean_hours + 17 * George_hours >= 40, name="Constraint_1")
m.addConstr(3 * Bobby_hours + 15 * Jean_hours + 17 * George_hours >= 38, name="Constraint_2")
m.addConstr(3 * Bobby_hours + 15 * Jean_hours + 12 * Hank_hours + 17 * George_hours >= 38, name="Constraint_3")
m.addConstr(-3 * Hank_hours + 10 * George_hours >= 0, name="Constraint_4")
m.addConstr(3 * Bobby_hours + 17 * George_hours <= 113, name="Constraint_5")
m.addConstr(3 * Bobby_hours + 12 * Hank_hours + 17 * George_hours <= 52, name="Constraint_6")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bobby hours: {Bobby_hours.x}")
    print(f"Jean hours: {Jean_hours.x}")
    print(f"Hank hours: {Hank_hours.x}")
    print(f"George hours: {George_hours.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
