
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    bobby_hours = model.addVar(name="bobby_hours", lb=0)  # No lower bound specified, assuming 0
    jean_hours = model.addVar(name="jean_hours", lb=0)    # No lower bound specified, assuming 0
    hank_hours = model.addVar(name="hank_hours", lb=0, integrality=gurobi.GRB.INTEGER)
    george_hours = model.addVar(name="george_hours", lb=0)

    # Objective function
    model.setObjective(9 * bobby_hours + 8 * jean_hours + 2 * hank_hours + 6 * george_hours, gurobi.GRB.MINIMIZE)

    # Constraints
    # Individual dollar costs per hour (not directly constraints, but part of the problem description)
    # Combined dollar costs per hour
    model.addConstraint(15 * jean_hours + 17 * george_hours >= 40)
    model.addConstraint(3 * bobby_hours + 15 * jean_hours + 17 * george_hours >= 38)
    model.addConstraint(3 * bobby_hours + 15 * jean_hours + 12 * hank_hours + 17 * george_hours >= 38)

    # Linear constraint
    model.addConstraint(-3 * hank_hours + 10 * george_hours >= 0)

    # Upper bounds on combined dollar costs per hour
    model.addConstraint(3 * bobby_hours + 17 * george_hours <= 113)
    model.addConstraint(3 * bobby_hours + 12 * hank_hours + 17 * george_hours <= 52)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Bobby hours: ", bobby_hours.varValue)
        print("Jean hours: ", jean_hours.varValue)
        print("Hank hours: ", hank_hours.varValue)
        print("George hours: ", george_hours.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
