
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens") # rotisserie chickens
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="eggs") # eggs
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars") # granola bars

# Set objective function
m.setObjective(3*x0**2 + 2*x0*x1 + 7*x0*x2 + x1**2 + 2*x1*x2 + x2**2 + x0 + 9*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x0 + 3*x1 + 11*x2 <= 221, "c0") # Healthiness rating constraint
m.addConstr(8*x0 + 9*x1 + 9*x2 <= 127, "c1") # Sourness index constraint
m.addConstr((10*x0)**2 + (11*x2)**2 >= 69, "c2") # Combined healthiness rating (rotisserie chickens and granola bars)
m.addConstr(3*x1 + 11*x2 >= 65, "c3") # Combined healthiness rating (eggs and granola bars)
m.addConstr(8*x0 + 9*x2 >= 16, "c4") # Combined sourness index (rotisserie chickens and granola bars)
m.addConstr(3*x1 + 11*x2 <= 184, "c5") # Combined healthiness rating (eggs and granola bars)
m.addConstr(10*x0 + 3*x1 <= 209, "c6") # Combined healthiness rating (rotisserie chickens and eggs)
m.addConstr(10*x0 + 3*x1 + 11*x2 <= 209, "c7") # Combined healthiness rating (rotisserie chickens, eggs, and granola bars)
m.addConstr((8*x0)**2 + (9*x2)**2 <= 87, "c8") # Combined sourness index (rotisserie chickens and granola bars)
m.addConstr((9*x1)**2 + (9*x2)**2 <= 82, "c9") # Combined sourness index (eggs and granola bars)
m.addConstr(8*x0 + 9*x1 + 9*x2 <= 82, "c10") # Combined sourness index (rotisserie chickens, eggs, and granola bars)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('rotisserie_chickens:', x0.x)
    print('eggs:', x1.x)
    print('granola_bars:', x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
