
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="rotisserie_chickens", vtype=GRB.CONTINUOUS)  # Rotisserie chickens can be non-integer
x1 = m.addVar(lb=0, name="eggs", vtype=GRB.INTEGER)  # Eggs must be integer
x2 = m.addVar(lb=0, name="granola_bars", vtype=GRB.CONTINUOUS)  # Granola bars can be non-integer

# Objective function: Maximize
m.setObjective(3*x0**2 + 2*x0*x1 + 7*x0*x2 + x1**2 + 2*x1*x2 + x2**2 + x0 + 9*x1 + 7*x2, GRB.MAXIMIZE)

# Constraints
# Healthiness rating constraints
m.addConstr(10*x0 + 3*x1 + 11*x2 <= 209, name="total_healthiness_max")  # Total healthiness max
m.addConstr(10*x0 + 3*x1 <= 209, name="rotisserie_and_eggs_healthiness_max")  # Rotisserie and eggs healthiness max

# Minimum combined healthiness ratings
m.addConstr(10*x0**2 + 11*x2**2 >= 69, name="min_rotisserie_granola_healthiness_squared")
m.addConstr(3*x1 + 11*x2 >= 65, name="min_eggs_granola_healthiness")

# Sourness index constraints
m.addConstr(8*x0 + 9*x1 + 9*x2 <= 82, name="total_sourness_max")  # Total sourness max
m.addConstr(8*x0**2 + 9*x2**2 <= 87, name="rotisserie_granola_sourness_squared_max")
m.addConstr(9*x1**2 + 9*x2**2 <= 82, name="eggs_granola_sourness_squared_max")

# Minimum combined sourness index
m.addConstr(8*x0 + 9*x2 >= 16, name="min_rotisserie_granola_sourness")

# Additional healthiness constraint
m.addConstr(3*x1 + 11*x2 <= 184, name="eggs_granola_healthiness_max")  # Eggs and granola max healthiness

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal}")
    print(f"Rotisserie chickens: {x0.x}, Eggs: {x1.x}, Granola bars: {x2.x}")
else:
    print("No optimal solution found")
