
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="rotisserie_chickens")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="eggs", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="granola_bars")

    # Define objective function
    model.setObjective(3*x0**2 + 2*x0*x1 + 7*x0*x2 + x1**2 + 2*x1*x2 + x2**2 + x0 + 9*x1 + 7*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*x0 + 3*x1 + 11*x2 >= 69)
    model.addConstr(9*x1 + 11*x2 >= 65)
    model.addConstr(8*x0 + 9*x2 >= 16)
    model.addConstr(3*x1 + 11*x2 <= 184)
    model.addConstr(10*x0 + 3*x1 <= 209)
    model.addConstr(10*x0 + 3*x1 + 11*x2 <= 209)
    model.addConstr(64*x0**2 + 81*x2**2 <= 87)
    model.addConstr(81*x1**2 + 81*x2**2 <= 82)
    model.addConstr(8*x0 + 9*x1 + 9*x2 <= 82)

    # Update model
    model.update()

    # Solve model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("rotisserie_chickens: ", x0.varValue)
        print("eggs: ", x1.varValue)
        print("granola_bars: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
