
from gurobipy import Model, GRB

# Create a new model
model = Model("PlantOptimization")

# Create variables
vincas = model.addVar(vtype=GRB.INTEGER, name="vincas")
roses = model.addVar(vtype=GRB.INTEGER, name="roses")
bean_stalks = model.addVar(vtype=GRB.INTEGER, name="bean_stalks")
chives = model.addVar(vtype=GRB.INTEGER, name="chives")

# Set objective function
model.setObjective(3 * vincas + 1 * roses + 7 * bean_stalks + 7 * chives, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * vincas + 10 * bean_stalks >= 33, "c1")  # Spending on vincas and bean stalks
model.addConstr(10 * roses + 9 * chives >= 33, "c2")  # Spending on roses and chives
model.addConstr(3 * vincas + 10 * roses + 10 * bean_stalks + 9 * chives >= 33, "c3")  # Total spending
model.addConstr(10 * roses + 11 * bean_stalks >= 22, "c4")  # Resilience - roses and bean stalks
model.addConstr(11 * bean_stalks + 7 * chives >= 26, "c5")  # Resilience - bean stalks and chives
model.addConstr(10 * vincas + 10 * roses >= 20, "c6")  # Resilience - vincas and roses
model.addConstr(10 * vincas + 11 * bean_stalks >= 15, "c7")  # Resilience - vincas and bean stalks
model.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks >= 25, "c8")  # Resilience - vincas, roses, bean stalks
model.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 25, "c9")  # Resilience - roses, bean stalks, chives
model.addConstr(10 * vincas + 10 * roses + 7 * chives >= 25, "c10")  # Resilience - vincas, roses, chives
model.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks >= 30, "c11")  # Resilience - vincas, roses, bean stalks
model.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 30, "c12")  # Resilience - roses, bean stalks, chives
model.addConstr(10 * vincas + 10 * roses + 7 * chives >= 30, "c13")  # Resilience - vincas, roses, chives
model.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks >= 41, "c14")  # Resilience - vincas, roses, bean stalks
model.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 41, "c15")  # Resilience - roses, bean stalks, chives
model.addConstr(10 * vincas + 10 * roses + 7 * chives >= 41, "c16")  # Resilience - vincas, roses, chives
model.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks + 7 * chives >= 41, "c17")  # Resilience - all
model.addConstr(10 * roses + 10 * bean_stalks <= 159, "c18")  # Spending - roses and bean stalks
model.addConstr(3 * vincas + 10 * roses <= 138, "c19")  # Spending - vincas and roses
model.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks <= 75, "c20")  # Resilience - vincas, roses, bean stalks
model.addConstr(10 * vincas + 10 * roses + 7 * chives <= 93, "c21")  # Resilience - vincas, roses, chives


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('vincas:', vincas.x)
    print('roses:', roses.x)
    print('bean_stalks:', bean_stalks.x)
    print('chives:', chives.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
