
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
vincas = m.addVar(name="vincas", vtype=gurobi.GRB.INTEGER)
roses = m.addVar(name="roses", vtype=gurobi.GRB.INTEGER)
bean_stalks = m.addVar(name="bean_stalks", vtype=gurobi.GRB.INTEGER)
chives = m.addVar(name="chives", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(3 * vincas + roses + 7 * bean_stalks + 7 * chives, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(3 * vincas + 10 * bean_stalks >= 33, name="cost_vincas_bean_stalks")
m.addConstr(10 * roses + 9 * chives >= 33, name="cost_roses_chives")
m.addConstr(3 * vincas + 10 * roses + 10 * bean_stalks + 9 * chives >= 33, name="total_cost")
m.addConstr(10 * roses + 11 * bean_stalks >= 22, name="resilience_roses_bean_stalks")
m.addConstr(11 * bean_stalks + 7 * chives >= 26, name="resilience_bean_stalks_chives")
m.addConstr(10 * vincas + 10 * roses >= 20, name="resilience_vincas_roses")
m.addConstr(10 * vincas + 11 * bean_stalks >= 15, name="resilience_vincas_bean_stalks")
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks >= 25, name="resilience_vincas_roses_bean_stalks")
m.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 25, name="resilience_roses_bean_stalks_chives")
m.addConstr(10 * vincas + 10 * roses + 7 * chives >= 25, name="resilience_vincas_roses_chives")
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks >= 30, name="resilience_vincas_roses_bean_stalks_30")
m.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 30, name="resilience_roses_bean_stalks_chives_30")
m.addConstr(10 * vincas + 10 * roses + 7 * chives >= 30, name="resilience_vincas_roses_chives_30")
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks + 7 * chives >= 41, name="resilience_all")
m.addConstr(10 * roses + 11 * bean_stalks + 7 * chives >= 41, name="resilience_roses_bean_stalks_chives_41")
m.addConstr(10 * vincas + 10 * roses + 7 * chives >= 41, name="resilience_vincas_roses_chives_41")
m.addConstr(10 * roses + 10 * bean_stalks <= 159, name="cost_roses_bean_stalks")
m.addConstr(3 * vincas + 10 * roses <= 138, name="cost_vincas_roses")
m.addConstr(10 * vincas + 10 * roses + 11 * bean_stalks <= 75, name="resilience_vincas_roses_bean_stalks_75")
m.addConstr(10 * vincas + 10 * roses + 7 * chives <= 93, name="resilience_vincas_roses_chives_93")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Vincas: ", vincas.varValue)
    print("Roses: ", roses.varValue)
    print("Bean Stalks: ", bean_stalks.varValue)
    print("Chives: ", chives.varValue)
else:
    print("The model is infeasible")
