
from gurobipy import *

# Define the model
m = Model("Optimization_Problem")

# Define variables
cantaloupes = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")
slices_of_pizza = m.addVar(vtype=GRB.CONTINUOUS, name="slices_of_pizza")
oreos = m.addVar(vtype=GRB.INTEGER, name="oreos")
cherry_pies = m.addVar(vtype=GRB.CONTINUOUS, name="cherry_pies")
tomatoes = m.addVar(vtype=GRB.CONTINUOUS, name="tomatoes")

# Objective function
m.setObjective(7*cantaloupes + 3*slices_of_pizza + 9*oreos + 1*cherry_pies + 4*tomatoes, GRB.MINIMIZE)

# Constraints based on umami index
m.addConstr(13*cantaloupes + 14*slices_of_pizza <= 282)
m.addConstr(13*cantaloupes + 14*slices_of_pizza + 19*cherry_pies >= 31)
m.addConstr(13*oreos + 14*tomatoes >= 26)
m.addConstr(19*cherry_pies + 14*tomatoes >= 22)
m.addConstr(13*cantaloupes + 14*slices_of_pizza + 19*cherry_pies >= 31)
m.addConstr(13*oreos + 19*cherry_pies >= 39)
m.addConstr(13*cantaloupes + 14*slices_of_pizza <= 184)

# Constraints based on grams of protein
m.addConstr(15*cantaloupes + 14*slices_of_pizza + 9*cherry_pies >= 29)
m.addConstr(12*oreos + 9*cherry_pies >= 24)
m.addConstr(15*cantaloupes + 15*tomatoes >= 42)

# Constraints based on grams of fat
m.addConstr(16*cantaloupes + 20*slices_of_pizza >= 46)
m.addConstr(13*oreos + 19*cherry_pies >= 22)
m.addConstr(12*tomatoes + 19*cherry_pies >= 49)

# Constraints based on milligrams of calcium
m.addConstr(9*cantaloupes + 11*slices_of_pizza >= 30)
m.addConstr(12*oreos + 8*tomatoes >= 29)
m.addConstr(12*cherry_pies + 8*tomatoes >= 16)

# Additional constraints
m.addConstr(-3*cantaloupes + 10*oreos >= 0)

# Solve the model
m.optimize()

