
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
cantaloupes = m.addVar(name="cantaloupes", vtype=GRB.INTEGER)
slices_of_pizza = m.addVar(name="slices_of_pizza")
oreos = m.addVar(name="oreos", vtype=GRB.INTEGER)
cherry_pies = m.addVar(name="cherry_pies")
tomatoes = m.addVar(name="tomatoes")

# Define the objective function
m.setObjective(7 * cantaloupes + 3 * slices_of_pizza + 9 * oreos + cherry_pies + 4 * tomatoes, GRB.MINIMIZE)

# Resource attributes
r0 = {"cantaloupes": 13, "slices_of_pizza": 14, "oreos": 13, "cherry_pies": 19, "tomatoes": 14}
r1 = {"cantaloupes": 15, "slices_of_pizza": 14, "oreos": 12, "cherry_pies": 9, "tomatoes": 15}
r2 = {"cantaloupes": 16, "slices_of_pizza": 20, "oreos": 13, "cherry_pies": 19, "tomatoes": 12}
r3 = {"cantaloupes": 9, "slices_of_pizza": 11, "oreos": 12, "cherry_pies": 12, "tomatoes": 8}

# Constraints
# Umami index constraints
m.addConstr(r0["slices_of_pizza"] * slices_of_pizza + r0["cherry_pies"] * cherry_pies >= 33)
m.addConstr(r0["oreos"] * oreos + r0["tomatoes"] * tomatoes >= 26)
m.addConstr(r0["oreos"] * oreos + r0["cherry_pies"] * cherry_pies >= 39)
m.addConstr(r0["cherry_pies"] * cherry_pies + r0["tomatoes"] * tomatoes >= 22)
m.addConstr(r0["oreos"] * oreos + r0["cherry_pies"] * cherry_pies + r0["tomatoes"] * tomatoes >= 31)
m.addConstr(r0["slices_of_pizza"] * slices_of_pizza + r0["oreos"] * oreos + r0["cherry_pies"] * cherry_pies >= 31)
m.addConstr(r0["cantaloupes"] * cantaloupes + r0["slices_of_pizza"] * slices_of_pizza + r0["cherry_pies"] * cherry_pies >= 31)
m.addConstr(r0["oreos"] * oreos + r0["cherry_pies"] * cherry_pies + r0["tomatoes"] * tomatoes >= 48)
m.addConstr(r0["slices_of_pizza"] * slices_of_pizza + r0["oreos"] * oreos + r0["cherry_pies"] * cherry_pies >= 48)
m.addConstr(r0["cantaloupes"] * cantaloupes + r0["slices_of_pizza"] * slices_of_pizza + r0["cherry_pies"] * cherry_pies >= 48)
m.addConstr(r0["oreos"] * oreos + r0["cherry_pies"] * cherry_pies + r0["tomatoes"] * tomatoes >= 41)
m.addConstr(r0["slices_of_pizza"] * slices_of_pizza + r0["oreos"] * oreos + r0["cherry_pies"] * cherry_pies >= 41)
m.addConstr(r0["cantaloupes"] * cantaloupes + r0["slices_of_pizza"] * slices_of_pizza + r0["cherry_pies"] * cherry_pies >= 41)
m.addConstr(r0["cantaloupes"] * cantaloupes + r0["slices_of_pizza"] * slices_of_pizza + r0["oreos"] * oreos + r0["cherry_pies"] * cherry_pies + r0["tomatoes"] * tomatoes >= 41)

# Protein constraints
m.addConstr(r1["slices_of_pizza"] * slices_of_pizza + r1["cherry_pies"] * cherry_pies >= 49)
m.addConstr(r1["cherry_pies"] * cherry_pies + r1["tomatoes"] * tomatoes >= 22)
m.addConstr(r1["oreos"] * oreos + r1["cherry_pies"] * cherry_pies >= 24)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["tomatoes"] * tomatoes >= 42)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["slices_of_pizza"] * slices_of_pizza >= 22)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["cherry_pies"] * cherry_pies >= 47)
m.addConstr(r1["slices_of_pizza"] * slices_of_pizza + r1["tomatoes"] * tomatoes >= 26)
m.addConstr(r1["slices_of_pizza"] * slices_of_pizza + r1["oreos"] * oreos + r1["cherry_pies"] * cherry_pies >= 29)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["slices_of_pizza"] * slices_of_pizza + r1["cherry_pies"] * cherry_pies >= 29)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["oreos"] * oreos + r1["tomatoes"] * tomatoes >= 29)
m.addConstr(r1["slices_of_pizza"] * slices_of_pizza + r1["oreos"] * oreos + r1["cherry_pies"] * cherry_pies >= 47)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["slices_of_pizza"] * slices_of_pizza + r1["cherry_pies"] * cherry_pies >= 47)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["oreos"] * oreos + r1["tomatoes"] * tomatoes >= 47)

# Fat constraints
m.addConstr(r2["cantaloupes"] * cantaloupes + r2["tomatoes"] * tomatoes >= 41)
m.addConstr(r2["slices_of_pizza"] * slices_of_pizza + r2["oreos"] * oreos >= 22)
m.addConstr(r2["cantaloupes"] * cantaloupes + r2["oreos"] * oreos >= 47)
m.addConstr(r2["oreos"] * oreos + r2["cherry_pies"] * cherry_pies >= 22)
m.addConstr(r2["cantaloupes"] * cantaloupes + r2["slices_of_pizza"] * slices_of_pizza >= 46)
m.addConstr(r2["oreos"] * oreos + r2["tomatoes"] * tomatoes >= 40)
m.addConstr(r2["cherry_pies"] * cherry_pies + r2["tomatoes"] * tomatoes >= 49)
m.addConstr(r2["cantaloupes"] * cantaloupes + r2["cherry_pies"] * cherry_pies >= 52)
m.addConstr(r2["cantaloupes"] * cantaloupes + r2["slices_of_pizza"] * slices_of_pizza + r2["cherry_pies"] * cherry_pies >= 41)

# Calcium constraints
m.addConstr(r3["oreos"] * oreos + r3["tomatoes"] * tomatoes >= 29)
m.addConstr(r3["slices_of_pizza"] * slices_of_pizza + r3["tomatoes"] * tomatoes >= 26)
m.addConstr(r3["cherry_pies"] * cherry_pies + r3["tomatoes"] * tomatoes >= 16)
m.addConstr(r3["cantaloupes"] * cantaloupes + r3["oreos"] * oreos >= 10)
m.addConstr(r3["cantaloupes"] * cantaloupes + r3["cherry_pies"] * cherry_pies >= 18)
m.addConstr(r3["cantaloupes"] * cantaloupes + r3["slices_of_pizza"] * slices_of_pizza >= 30)

# Other constraints
m.addConstr(-3 * cantaloupes + 10 * oreos >= 0)
m.addConstr(r0["cantaloupes"] * cantaloupes + r0["slices_of_pizza"] * slices_of_pizza <= 282)
m.addConstr(r0["slices_of_pizza"] * slices_of_pizza + r0["tomatoes"] * tomatoes <= 182)
m.addConstr(r0["oreos"] * oreos + r0["tomatoes"] * tomatoes <= 217)
m.addConstr(r0["slices_of_pizza"] * slices_of_pizza + r0["cherry_pies"] * cherry_pies <= 210)
m.addConstr(r0["cantaloupes"] * cantaloupes + r0["tomatoes"] * tomatoes <= 232)
m.addConstr(r0["cherry_pies"] * cherry_pies + r0["tomatoes"] * tomatoes <= 270)
m.addConstr(r0["cantaloupes"] * cantaloupes + r0["cherry_pies"] * cherry_pies + r0["tomatoes"] * tomatoes <= 93)

# Bounds
m.addConstr(r1["slices_of_pizza"] * slices_of_pizza + r1["cherry_pies"] * cherry_pies <= 60)
m.addConstr(r1["cherry_pies"] * cherry_pies + r1["tomatoes"] * tomatoes <= 242)
m.addConstr(r1["oreos"] * oreos + r1["tomatoes"] * tomatoes <= 221)
m.addConstr(r1["oreos"] * oreos + r1["cherry_pies"] * cherry_pies <= 213)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["tomatoes"] * tomatoes <= 232)
m.addConstr(r1["slices_of_pizza"] * slices_of_pizza + r1["oreos"] * oreos <= 67)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["cherry_pies"] * cherry_pies <= 243)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["slices_of_pizza"] * slices_of_pizza <= 203)
m.addConstr(r1["cantaloupes"] * cantaloupes + r1["slices_of_pizza"] * slices_of_pizza + r1["cherry_pies"] * cherry_pies <= 158)

# Fat bounds
m.addConstr(r2["slices_of_pizza"] * slices_of_pizza + r2["oreos"] * oreos + r2["tomatoes"] * tomatoes <= 136)
m.addConstr(r2["slices_of_pizza"] * slices_of_pizza + r2["cherry_pies"] * cherry_pies + r2["tomatoes"] * tomatoes <= 246)
m.addConstr(r2["cantaloupes"] * cantaloupes + r2["cherry_pies"] * cherry_pies + r2["tomatoes"] * tomatoes <= 145)
m.addConstr(r2["cantaloupes"] * cantaloupes + r2["oreos"] * oreos + r2["tomatoes"] * tomatoes <= 249)

# Calcium bounds
m.addConstr(r3["cantaloupes"] * cantaloupes + r3["slices_of_pizza"] * slices_of_pizza <= 138)
m.addConstr(r3["oreos"] * oreos + r3["tomatoes"] * tomatoes <= 33)
m.addConstr(r3["cantaloupes"] * cantaloupes + r3["cherry_pies"] * cherry_pies <= 150)
m.addConstr(r3["cherry_pies"] * cherry_pies + r3["tomatoes"] * tomatoes <= 97)
m.addConstr(r3["slices_of_pizza"] * slices_of_pizza + r3["tomatoes"] * tomatoes <= 154)
m.addConstr(r3["cantaloupes"] * cantaloupes + r3["oreos"] * oreos <= 154)

# Optimize
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Cantaloupes: ", cantaloupes.varValue)
    print("Slices of Pizza: ", slices_of_pizza.varValue)
    print("Oreos: ", oreos.varValue)
    print("Cherry Pies: ", cherry_pies.varValue)
    print("Tomatoes: ", tomatoes.varValue)
else:
    print("No solution found")
