
import gurobipy as gp

# Create a new model
m = gp.Model("Resource_Allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="air_defense_batteries")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry_companies")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="pathfinder_teams")

# Set objective function
m.setObjective(2.9 * x0 + 9.71 * x1 + 3.61 * x2 + 3.39 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * x0 + 15 * x1 + 11 * x2 + 11 * x3 <= 208, "Fuel_Demand_UB") # Total fuel demand upper bound
m.addConstr(3 * x0 + 21 * x1 + 12 * x2 + 1 * x3 <= 84, "Deployment_Weight_UB") # Total deployment weight upper bound

m.addConstr(11 * x2 + 11 * x3 >= 38, "c1")
m.addConstr(15 * x1 + 11 * x3 >= 20, "c2")
m.addConstr(3 * x0 + 15 * x1 >= 48, "c3")
m.addConstr(3 * x0 + 11 * x2 >= 17, "c4")
m.addConstr(15 * x1 + 11 * x2 + 11 * x3 >= 40, "c5")
m.addConstr(3 * x0 + 11 * x2 + 11 * x3 >= 40, "c6")
m.addConstr(3 * x0 + 15 * x1 + 11 * x3 >= 40, "c7")
m.addConstr(15 * x1 + 11 * x2 + 11 * x3 >= 50, "c8")
m.addConstr(3 * x0 + 11 * x2 + 11 * x3 >= 50, "c9")
m.addConstr(3 * x0 + 15 * x1 + 11 * x3 >= 50, "c10")
m.addConstr(15 * x1 + 11 * x2 + 11 * x3 >= 50, "c11")
m.addConstr(3 * x0 + 11 * x2 + 11 * x3 >= 50, "c12")
m.addConstr(3 * x0 + 15 * x1 + 11 * x3 >= 50, "c13")

m.addConstr(21 * x1 + 12 * x2 >= 7, "c14")
m.addConstr(12 * x2 + 1 * x3 >= 16, "c15")
m.addConstr(3 * x0 + 12 * x2 >= 8, "c16")
m.addConstr(3 * x0 + 21 * x1 >= 13, "c17")
m.addConstr(21 * x1 + 12 * x2 + 1 * x3 >= 18, "c18")
m.addConstr(3 * x0 + 21 * x1 + 1 * x3 >= 18, "c19")
m.addConstr(3 * x0 + 12 * x2 + 1 * x3 >= 18, "c20")
m.addConstr(21 * x1 + 12 * x2 + 1 * x3 >= 19, "c21")
m.addConstr(3 * x0 + 21 * x1 + 1 * x3 >= 19, "c22")
m.addConstr(3 * x0 + 12 * x2 + 1 * x3 >= 19, "c23")
m.addConstr(21 * x1 + 12 * x2 + 1 * x3 >= 11, "c24")
m.addConstr(3 * x0 + 21 * x1 + 1 * x3 >= 11, "c25")
m.addConstr(3 * x0 + 12 * x2 + 1 * x3 >= 11, "c26")


m.addConstr(15 * x1 + 11 * x3 <= 181, "c27")
m.addConstr(3 * x0 + 11 * x3 <= 177, "c28")
m.addConstr(3 * x0 + 15 * x1 <= 133, "c29")
m.addConstr(15 * x1 + 11 * x2 <= 93, "c30")
m.addConstr(15 * x1 + 11 * x2 + 11 * x3 <= 164, "c31")
m.addConstr(3 * x0 + 15 * x1 + 11 * x2 + 11 * x3 <= 164, "c32")

m.addConstr(3 * x0 + 21 * x1 <= 41, "c33")
m.addConstr(21 * x1 + 12 * x2 <= 30, "c34")
m.addConstr(12 * x2 + 1 * x3 <= 43, "c35")
m.addConstr(3 * x0 + 21 * x1 + 12 * x2 + 1 * x3 <= 43, "c36")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

