
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
air_defense_batteries = m.addVar(name="air_defense_batteries", vtype=gurobi.GRB.INTEGER)
light_infantry_companies = m.addVar(name="light_infantry_companies", vtype=gurobi.GRB.INTEGER)
CBRN_platoons = m.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
pathfinder_teams = m.addVar(name="pathfinder_teams", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(2.9 * air_defense_batteries + 9.71 * light_infantry_companies + 
               3.61 * CBRN_platoons + 3.39 * pathfinder_teams, gurobi.GRB.MAXIMIZE)

# Define the constraints
# Fuel demand constraints
m.addConstr(3 * air_defense_batteries + 15 * light_infantry_companies + 
             11 * CBRN_platoons + 11 * pathfinder_teams <= 164)
m.addConstr(3 * air_defense_batteries + 15 * light_infantry_companies <= 133)
m.addConstr(15 * light_infantry_companies + 11 * CBRN_platoons <= 93)
m.addConstr(15 * light_infantry_companies + 11 * CBRN_platoons + 11 * pathfinder_teams <= 164)
m.addConstr(3 * air_defense_batteries + 11 * CBRN_platoons + 11 * pathfinder_teams >= 50)
m.addConstr(3 * air_defense_batteries + 15 * light_infantry_companies >= 48)
m.addConstr(3 * air_defense_batteries + 11 * CBRN_platoons >= 17)
m.addConstr(15 * light_infantry_companies + 11 * CBRN_platoons + 11 * pathfinder_teams >= 40)
m.addConstr(3 * air_defense_batteries + 15 * light_infantry_companies + 11 * pathfinder_teams >= 40)
m.addConstr(15 * light_infantry_companies + 11 * CBRN_platoons + 11 * pathfinder_teams >= 50)
m.addConstr(3 * air_defense_batteries + 11 * CBRN_platoons >= 38)
m.addConstr(15 * light_infantry_companies + 11 * pathfinder_teams >= 20)

# Deployment weight constraints
m.addConstr(3 * air_defense_batteries + 21 * light_infantry_companies + 
             12 * CBRN_platoons + 1 * pathfinder_teams <= 43)
m.addConstr(21 * light_infantry_companies + 12 * CBRN_platoons <= 30)
m.addConstr(12 * CBRN_platoons + 1 * pathfinder_teams <= 43)
m.addConstr(3 * air_defense_batteries + 21 * light_infantry_companies <= 41)
m.addConstr(3 * air_defense_batteries + 12 * CBRN_platoons >= 8)
m.addConstr(21 * light_infantry_companies + 12 * CBRN_platoons + 1 * pathfinder_teams >= 18)
m.addConstr(3 * air_defense_batteries + 21 * light_infantry_companies + 1 * pathfinder_teams >= 18)
m.addConstr(3 * air_defense_batteries + 12 * CBRN_platoons + 1 * pathfinder_teams >= 18)
m.addConstr(21 * light_infantry_companies + 12 * CBRN_platoons + 1 * pathfinder_teams >= 19)
m.addConstr(3 * air_defense_batteries + 21 * light_infantry_companies + 1 * pathfinder_teams >= 19)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Air defense batteries:", air_defense_batteries.varValue)
    print("Light infantry companies:", light_infantry_companies.varValue)
    print("CBRN platoons:", CBRN_platoons.varValue)
    print("Pathfinder teams:", pathfinder_teams.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
