
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b12")
b3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="b3")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")

# Set objective function
m.setObjective(7.5 * zinc + 5.18 * b12 + 3.52 * b3 + 8.91 * vitamin_c, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * zinc + 1 * b12 >= 36, "c1")
m.addConstr(5 * zinc + 18 * b3 >= 19, "c2")
m.addConstr(1 * b12 + 18 * b3 + 19 * vitamin_c >= 29, "c3")
m.addConstr(5 * zinc + 1 * b12 + 19 * vitamin_c >= 29, "c4")
m.addConstr(5 * zinc + 18 * b3 + 19 * vitamin_c >= 29, "c5")
m.addConstr(1 * b12 + 18 * b3 + 19 * vitamin_c >= 42, "c6")
m.addConstr(5 * zinc + 1 * b12 + 19 * vitamin_c >= 42, "c7")
m.addConstr(5 * zinc + 18 * b3 + 19 * vitamin_c >= 42, "c8")
m.addConstr(1 * b12 + 18 * b3 + 19 * vitamin_c >= 32, "c9")
m.addConstr(5 * zinc + 1 * b12 + 19 * vitamin_c >= 32, "c10")
m.addConstr(5 * zinc + 18 * b3 + 19 * vitamin_c >= 32, "c11")
m.addConstr(5 * zinc + 1 * b12 + 18 * b3 + 19 * vitamin_c >= 32, "c12")
m.addConstr(2 * b12 + 5 * vitamin_c >= 69, "c13")
m.addConstr(2 * b12 + 13 * b3 >= 61, "c14")
m.addConstr(5 * zinc + 13 * b3 >= 64, "c15")
m.addConstr(5 * zinc + 5 * vitamin_c >= 30, "c16")
m.addConstr(5 * zinc + 13 * b3 + 5 * vitamin_c >= 77, "c17")
m.addConstr(5 * zinc + 2 * b12 + 13 * b3 + 5 * vitamin_c >= 77, "c18")
m.addConstr(8 * b12 - 4 * b3 >= 0, "c19")
m.addConstr(5 * zinc + 1 * b12 + 19 * vitamin_c <= 100, "c20")
m.addConstr(5 * zinc + 1 * b12 + 18 * b3 <= 194, "c21")
m.addConstr(5 * zinc + 18 * b3 + 19 * vitamin_c <= 74, "c22")
m.addConstr(5 * zinc + 2 * b12 + 13 * b3 <= 279, "c23")
m.addConstr(5 * zinc + 2 * b12 + 5 * vitamin_c <= 292, "c24")
m.addConstr(5 * zinc + 13 * b3 + 5 * vitamin_c <= 166, "c25")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('zinc:', zinc.x)
    print('b12:', b12.x)
    print('b3:', b3.x)
    print('vitamin_c:', vitamin_c.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
