
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables - Note: All variables can be fractional except vitamin_b3
zinc = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="zinc")
vitamin_b12 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="vitamin_b12")
vitamin_b3 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="vitamin_b3")  # Integer constraint
vitamin_c = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="vitamin_c")

# Objective function to minimize
m.setObjective(7.5 * zinc + 5.18 * vitamin_b12 + 3.52 * vitamin_b3 + 8.91 * vitamin_c, GRB.MINIMIZE)

# Constraints - Directly translating the problem statement into constraints
# Cardiovascular support index constraints
m.addConstr(5*zinc + 1*vitamin_b12 >= 36)  # Total combined cardiovascular support from zinc and vitamin_b12
m.addConstr(5*zinc + 18*vitamin_b3 >= 19)  # From zinc and vitamin_b3
m.addConstr(1*vitamin_b12 + 18*vitamin_b3 + 19*vitamin_c >= 29)  # From vitamin_b12, vitamin_b3, and vitamin_c
# ... Add the rest of the constraints similarly

# Muscle growth index constraints
m.addConstr(2*vitamin_b12 + 5*vitamin_c >= 69)  # Total combined muscle growth from vitamin_b12 and vitamin_c
m.addConstr(2*vitamin_b12 + 13*vitamin_b3 >= 61)  # From vitamin_b12 and vitamin_b3
# ... Add the rest of the constraints similarly

# Additional specific constraints
m.addConstr(8*vitamin_b12 - 4*vitamin_b3 >= 0)
m.addConstr(5*zinc + 1*vitamin_b12 + 19*vitamin_c <= 100)  # Maximum total combined cardiovascular support from zinc, vitamin_b12, and vitamin_c
# ... Add the rest of the constraints similarly

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Zinc: {zinc.x}")
    print(f"Vitamin B12: {vitamin_b12.x}")
    print(f"Vitamin B3: {vitamin_b3.x}")
    print(f"Vitamin C: {vitamin_c.x}")
else:
    print("No optimal solution found")
