
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
z = m.addVar(name="zinc", lb=0)  # Fractional
b = m.addVar(name="vitamin_B12", lb=0)  # Fractional
n = m.addVar(name="vitamin_B3", lb=0, integrality=gp.GRB.INTEGER)  # Integer
c = m.addVar(name="vitamin_C", lb=0)  # Fractional

# Objective function
m.setObjective(7.5 * z + 5.18 * b + 3.52 * n + 8.91 * c, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5 * z + 1 * b >= 36)
m.addConstr(5 * z + 18 * n >= 19)
m.addConstr(1 * b + 18 * n + 19 * c >= 29)
m.addConstr(5 * z + 1 * b + 19 * c >= 29)
m.addConstr(5 * z + 18 * n + 19 * c >= 29)
m.addConstr(1 * b + 18 * n + 19 * c >= 42)
m.addConstr(5 * z + 1 * b + 19 * c >= 42)
m.addConstr(5 * z + 18 * n + 19 * c >= 42)
m.addConstr(1 * b + 18 * n + 19 * c >= 32)
m.addConstr(5 * z + 1 * b + 19 * c >= 32)
m.addConstr(5 * z + 18 * n + 19 * c >= 32)
m.addConstr(5 * z + 1 * b + 18 * n + 19 * c >= 32)
m.addConstr(2 * b + 5 * c >= 69)
m.addConstr(2 * b + 13 * n >= 61)
m.addConstr(5 * z + 13 * n >= 64)
m.addConstr(5 * z + 5 * c >= 30)
m.addConstr(5 * z + 13 * n + 5 * c >= 77)
m.addConstr(5 * z + 2 * b + 13 * n + 5 * c >= 77)
m.addConstr(8 * b - 4 * n >= 0)
m.addConstr(5 * z + 1 * b + 19 * c <= 100)
m.addConstr(5 * z + 1 * b + 18 * n <= 194)
m.addConstr(5 * z + 18 * n + 19 * c <= 74)
m.addConstr(5 * z + 2 * b + 13 * n <= 279)
m.addConstr(5 * z + 2 * b + 5 * c <= 292)
m.addConstr(5 * z + 13 * n + 5 * c <= 166)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Zinc: ", z.varValue)
    print("Vitamin B12: ", b.varValue)
    print("Vitamin B3: ", n.varValue)
    print("Vitamin C: ", c.varValue)
else:
    print("The model is infeasible")
