
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")

# Set objective function
m.setObjective(6 * bacon + 7 * cheeseburgers + 4 * potatoes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * bacon + 3 * potatoes >= 30, "c1")  # sourness bacon + potatoes
m.addConstr(13 * bacon + 9 * cheeseburgers + 3 * potatoes >= 30, "c2") # sourness all
m.addConstr(4 * cheeseburgers + 4 * potatoes >= 32, "c3") # cost cheeseburgers + potatoes
m.addConstr(14 * bacon + 4 * cheeseburgers + 4 * potatoes >= 32, "c4") # cost all
m.addConstr(24 * bacon + 21 * potatoes >= 28, "c5") # fat bacon + potatoes
m.addConstr(24 * bacon + 10 * cheeseburgers + 21 * potatoes >= 28, "c6") # fat all
m.addConstr(3 * bacon - 6 * cheeseburgers >= 0, "c7") # bacon vs cheeseburgers
m.addConstr(-4 * bacon + 6 * potatoes >= 0, "c8") # bacon vs potatoes
m.addConstr(9 * cheeseburgers + 3 * potatoes <= 136, "c9") # sourness cheeseburgers + potatoes
m.addConstr(13 * bacon + 9 * cheeseburgers + 3 * potatoes <= 86, "c10") # sourness all
m.addConstr(4 * cheeseburgers + 4 * potatoes <= 95, "c11") # cost cheeseburgers + potatoes
m.addConstr(14 * bacon + 4 * cheeseburgers <= 74, "c12") # cost bacon + cheeseburgers
m.addConstr(10 * cheeseburgers + 21 * potatoes <= 212, "c13") # fat cheeseburgers + potatoes


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

