
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables (can be non-integer)
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="strips_of_bacon")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")

# Objective function: Minimize 6*x0 + 7*x1 + 4*x2
m.setObjective(6*x0 + 7*x1 + 4*x2, GRB.MINIMIZE)

# Constraints:
# Total combined sourness index from strips of bacon and potatoes must be at least 30
m.addConstr(13*x0 + 3*x2 >= 30, name="sourness_bacon_potatoes")

# Total combined sourness index from all items has to be at least 30
m.addConstr(13*x0 + 9*x1 + 3*x2 >= 30, name="total_sourness_min")

# Spend at least $32 on cheeseburgers plus potatoes
m.addConstr(4*x1 + 4*x2 >= 32, name="cost_cheeseburgers_potatoes")

# Total cost of all items must be at least $32
m.addConstr(14*x0 + 4*x1 + 4*x2 >= 32, name="total_cost_min")

# At least 28 grams of fat from strips of bacon plus potatoes
m.addConstr(24*x0 + 21*x2 >= 28, name="fat_bacon_potatoes")

# At least 28 grams of fat from all items
m.addConstr(24*x0 + 10*x1 + 21*x2 >= 28, name="total_fat_min")

# Linear inequality constraints
m.addConstr(3*x0 - 6*x1 >= 0, name="linear_ineq1")
m.addConstr(-4*x0 + 6*x2 >= 0, name="linear_ineq2")

# Total combined sourness index from cheeseburgers plus potatoes must be no more than 136
m.addConstr(9*x1 + 3*x2 <= 136, name="sourness_cheeseburgers_potatoes_max")

# Total combined sourness index from all items must be as much or less than 147 (adjusted to reflect the problem's upper bound context)
m.addConstr(13*x0 + 9*x1 + 3*x2 <= 147, name="total_sourness_max")

# Spend no more than $95 on cheeseburgers and potatoes
m.addConstr(4*x1 + 4*x2 <= 95, name="cost_cheeseburgers_potatoes_max")

# Spend no more than $97 (adjusted to reflect the problem's upper bound context) on all items
m.addConstr(14*x0 + 4*x1 + 4*x2 <= 97, name="total_cost_max")

# Get at most 212 grams of fat from cheeseburgers and potatoes
m.addConstr(10*x1 + 21*x2 <= 212, name="fat_cheeseburgers_potatoes_max")

# Get at most 244 grams of fat (adjusted to reflect the problem's upper bound context) from all items
m.addConstr(24*x0 + 10*x1 + 21*x2 <= 244, name="total_fat_max")

# Optimize model
m.optimize()
