
import gurobi

def optimization_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    strips_of_bacon = m.addVar(name="strips_of_bacon", lb=0)  # Non-integer
    cheeseburgers = m.addVar(name="cheeseburgers", lb=0)  # Non-integer
    potatoes = m.addVar(name="potatoes", lb=0)  # Non-integer

    # Objective function
    m.setObjective(6 * strips_of_bacon + 7 * cheeseburgers + 4 * potatoes, gurobi.GRB.MINIMIZE)

    # Constraints
    # Sourness index constraints
    m.addConstr(13 * strips_of_bacon + 3 * potatoes >= 30, name="sourness_bacon_potatoes")
    m.addConstr(13 * strips_of_bacon + 9 * cheeseburgers + 3 * potatoes >= 30, name="sourness_all")
    m.addConstr(9 * cheeseburgers + 3 * potatoes <= 136, name="sourness_cheeseburgers_potatoes")
    m.addConstr(13 * strips_of_bacon + 9 * cheeseburgers + 3 * potatoes <= 86, name="sourness_all_upper")

    # Cost constraints
    m.addConstr(4 * cheeseburgers + 4 * potatoes >= 32, name="cost_cheeseburgers_potatoes")
    m.addConstr(14 * strips_of_bacon + 4 * cheeseburgers + 4 * potatoes >= 32, name="cost_all")
    m.addConstr(4 * cheeseburgers + 4 * potatoes <= 95, name="cost_cheeseburgers_potatoes_upper")
    m.addConstr(14 * strips_of_bacon + 4 * cheeseburgers <= 74, name="cost_bacon_cheeseburgers_upper")

    # Fat constraints
    m.addConstr(24 * strips_of_bacon + 21 * potatoes >= 28, name="fat_bacon_potatoes")
    m.addConstr(24 * strips_of_bacon + 10 * cheeseburgers + 21 * potatoes >= 28, name="fat_all")
    m.addConstr(10 * cheeseburgers + 21 * potatoes <= 212, name="fat_cheeseburgers_potatoes_upper")

    # Other constraints
    m.addConstr(3 * strips_of_bacon - 6 * cheeseburgers >= 0, name="other_constraint1")
    m.addConstr(-4 * strips_of_bacon + 6 * potatoes >= 0, name="other_constraint2")

    # Resource constraints (Implicit in variable definitions)

    # Solve the problem
    m.optimize()

    # Print the solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        print("Strips of bacon: ", strips_of_bacon.x)
        print("Cheeseburgers: ", cheeseburgers.x)
        print("Potatoes: ", potatoes.x)
    else:
        print("The problem is infeasible")

optimization_problem()
