
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
iron = m.addVar(lb=0, name="iron")  # milligrams of iron
vitamin_c = m.addVar(lb=0, name="vitamin_c")  # milligrams of vitamin C

# Set objective function
m.setObjective(3.43 * iron + 5.11 * vitamin_c, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * iron + 32 * vitamin_c >= 73, "digestive_support_min")
m.addConstr(1 * iron + 2 * vitamin_c >= 140, "cardiovascular_support_min")
m.addConstr(22 * iron + 16 * vitamin_c >= 58, "kidney_support_min")
m.addConstr(-2 * iron + 7 * vitamin_c >= 0, "custom_constraint")
m.addConstr(3 * iron + 32 * vitamin_c <= 147, "digestive_support_max")
m.addConstr(1 * iron + 2 * vitamin_c <= 213, "cardiovascular_support_max")
m.addConstr(22 * iron + 16 * vitamin_c <= 129, "kidney_support_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Iron: {iron.x}")
    print(f"Vitamin C: {vitamin_c.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

