
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
milligrams_of_iron = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_iron")
milligrams_of_vitamin_C = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Define the objective function
m.setObjective(3.43 * milligrams_of_iron + 5.11 * milligrams_of_vitamin_C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*milligrams_of_iron + 32*milligrams_of_vitamin_C >= 73, name="digestive_support_index_min")
m.addConstr(1*milligrams_of_iron + 2*milligrams_of_vitamin_C >= 140, name="cardiovascular_support_index_min")
m.addConstr(22*milligrams_of_iron + 16*milligrams_of_vitamin_C >= 58, name="kidney_support_index_min")
m.addConstr(-2*milligrams_of_iron + 7*milligrams_of_vitamin_C >= 0, name="linear_constraint")
m.addConstr(3*milligrams_of_iron + 32*milligrams_of_vitamin_C <= 147, name="digestive_support_index_max")
m.addConstr(1*milligrams_of_iron + 2*milligrams_of_vitamin_C <= 213, name="cardiovascular_support_index_max")
m.addConstr(22*milligrams_of_iron + 16*milligrams_of_vitamin_C <= 129, name="kidney_support_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Iron: {milligrams_of_iron.x}")
    print(f"Milligrams of Vitamin C: {milligrams_of_vitamin_C.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
