
import gurobi

def optimize_iron_vitamin_c():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    iron = model.addVar(name="iron", lb=0)  # No lower bound specified, assuming 0
    vitamin_c = model.addVar(name="vitamin_c", lb=0)  # No lower bound specified, assuming 0

    # Objective function
    model.setObjective(3.43 * iron + 5.11 * vitamin_c, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Digestive support index
    model.addConstraint(3 * iron + 32 * vitamin_c >= 73, name="digestive_support_min")
    model.addConstraint(3 * iron + 32 * vitamin_c <= 147, name="digestive_support_max")

    # Cardiovascular support index
    model.addConstraint(1 * iron + 2 * vitamin_c >= 140, name="cardiovascular_support_min")
    model.addConstraint(1 * iron + 2 * vitamin_c <= 213, name="cardiovascular_support_max")

    # Kidney support index
    model.addConstraint(22 * iron + 16 * vitamin_c >= 58, name="kidney_support_min")
    model.addConstraint(22 * iron + 16 * vitamin_c <= 129, name="kidney_support_max")

    # Additional constraint
    model.addConstraint(-2 * iron + 7 * vitamin_c >= 0, name="additional_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Iron: {iron.varValue}")
        print(f"Vitamin C: {vitamin_c.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_iron_vitamin_c()
