
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b6 = m.addVar(name="vitamin_b6", lb=0)
potassium = m.addVar(name="potassium", lb=0)
carbohydrates = m.addVar(name="carbohydrates", lb=0)
vitamin_b4 = m.addVar(name="vitamin_b4", lb=0)

# Set objective function
m.setObjective(8.98 * vitamin_b6 + 1.03 * potassium + 7.98 * carbohydrates + 3.6 * vitamin_b4, gp.GRB.MAXIMIZE)

# Add resource constraints
resources = {
    'r0': {'upper_bound': 77, 'x0': 2, 'x1': 5, 'x2': 5, 'x3': 2},
    'r1': {'upper_bound': 64, 'x1': 5, 'x2': 5, 'x3': 3, 'x0': 8},
    'r2': {'upper_bound': 80, 'x0': 8, 'x1': 3, 'x2': 1, 'x3': 5}
}

for r, data in resources.items():
    m.addConstr(data['x0'] * vitamin_b6 + data['x1'] * potassium + data['x2'] * carbohydrates + data['x3'] * vitamin_b4 <= data['upper_bound'], name=r)


# Add additional constraints
m.addConstr(5 * potassium + 2 * vitamin_b4 >= 12)
m.addConstr(5 * carbohydrates + 2 * vitamin_b4 >= 13)
m.addConstr(2 * vitamin_b6 + 5 * potassium + 2 * vitamin_b4 >= 10)
m.addConstr(2 * vitamin_b6 + 5 * carbohydrates + 2 * vitamin_b4 >= 10)
m.addConstr(2 * vitamin_b6 + 5 * potassium + 2 * vitamin_b4 >= 15)
m.addConstr(2 * vitamin_b6 + 5 * carbohydrates + 2 * vitamin_b4 >= 15)
m.addConstr(8 * vitamin_b6 + 5 * potassium + 5 * carbohydrates >= 14)
m.addConstr(8 * vitamin_b6 + 3 * potassium + 1 * carbohydrates >= 16)
m.addConstr(8 * vitamin_b6 + 1 * carbohydrates + 5 * vitamin_b4 >= 16)
m.addConstr(8 * vitamin_b6 + 3 * potassium + 1 * carbohydrates >= 12)
m.addConstr(8 * vitamin_b6 + 1 * carbohydrates + 5 * vitamin_b4 >= 12)
m.addConstr(5 * potassium + 2 * vitamin_b4 <= 52)
m.addConstr(2 * vitamin_b6 + 5 * potassium + 5 * carbohydrates + 2 * vitamin_b4 <= 52)
m.addConstr(8 * vitamin_b6 + 5 * potassium <= 37)
m.addConstr(8 * vitamin_b6 + 5 * carbohydrates <= 55)
m.addConstr(5 * potassium + 5 * carbohydrates <= 52)
m.addConstr(5 * potassium + 3 * vitamin_b4 <= 53)
m.addConstr(5 * potassium + 5 * carbohydrates + 3 * vitamin_b4 <= 28)
m.addConstr(8 * vitamin_b6 + 5 * potassium + 5 * carbohydrates + 3 * vitamin_b4 <= 28)
m.addConstr(3 * potassium + 1 * carbohydrates <= 64)
m.addConstr(1 * carbohydrates + 5 * vitamin_b4 <= 28)
m.addConstr(8 * vitamin_b6 + 1 * carbohydrates <= 56)
m.addConstr(3 * potassium + 5 * vitamin_b4 <= 74)
m.addConstr(8 * vitamin_b6 + 3 * potassium <= 53)
m.addConstr(8 * vitamin_b6 + 3 * potassium + 5 * vitamin_b4 <= 50)
m.addConstr(8 * vitamin_b6 + 3 * potassium + carbohydrates + 5 * vitamin_b4 <= 50)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

