
from gurobipy import Model, GRB

# Create a new model
model = Model("Food Optimization")

# Create variables
milkshakes = model.addVar(vtype=GRB.INTEGER, name="milkshakes")
ravioli = model.addVar(vtype=GRB.INTEGER, name="ravioli")
sashimi = model.addVar(vtype=GRB.INTEGER, name="sashimi")

# Set objective function
model.setObjective(4.36 * milkshakes + 8.29 * ravioli + 5.64 * sashimi, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * milkshakes + 9 * ravioli + 1 * sashimi <= 181, "c_fat_total")  # Total fat
model.addConstr(9 * milkshakes + 23 * ravioli + 25 * sashimi <= 434, "c_carb_total") # Total carbohydrates

model.addConstr(6 * milkshakes + 9 * ravioli >= 20, "c_fat_milkshakes_ravioli_min")
model.addConstr(9 * ravioli + 1 * sashimi >= 38, "c_fat_ravioli_sashimi_min")
model.addConstr(6 * milkshakes + 1 * sashimi >= 24, "c_fat_milkshakes_sashimi_min")
model.addConstr(6 * milkshakes + 9 * ravioli + 1 * sashimi >= 50, "c_fat_total_min")

model.addConstr(9 * milkshakes + 25 * sashimi >= 122, "c_carb_milkshakes_sashimi_min")

model.addConstr(6 * milkshakes + 9 * ravioli <= 131, "c_fat_milkshakes_ravioli_max")
model.addConstr(6 * milkshakes + 1 * sashimi <= 139, "c_fat_milkshakes_sashimi_max")
model.addConstr(6 * milkshakes + 9 * ravioli + 1 * sashimi <= 139, "c_fat_total_max")


model.addConstr(23 * ravioli + 25 * sashimi <= 286, "c_carb_ravioli_sashimi_max")
model.addConstr(9 * milkshakes + 25 * sashimi <= 384, "c_carb_milkshakes_sashimi_max")
model.addConstr(9 * milkshakes + 23 * ravioli <= 227, "c_carb_milkshakes_ravioli_max")
model.addConstr(9 * milkshakes + 23 * ravioli + 25 * sashimi <= 227, "c_carb_total_max")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print("Variable values:")
    for v in model.getVars():
        print(f"  {v.varName}: {v.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

