
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
milkshakes = m.addVar(vtype=GRB.INTEGER, name="milkshakes")
ravioli = m.addVar(vtype=GRB.INTEGER, name="ravioli")
sashimi = m.addVar(vtype=GRB.INTEGER, name="sashimi")

# Objective function
m.setObjective(4.36*milkshakes + 8.29*ravioli + 5.64*sashimi, GRB.MAXIMIZE)

# Constraints
# Fat constraints
m.addConstr(6*milkshakes + 9*ravioli >= 20, name="fat_milkshakes_ravioli")
m.addConstr(9*ravioli + sashimi >= 38, name="fat_ravioli_sashimi")
m.addConstr(6*milkshakes + sashimi >= 24, name="fat_milkshakes_sashimi")
m.addConstr(6*milkshakes + 9*ravioli + sashimi >= 50, name="fat_all")
m.addConstr(6*milkshakes + 9*ravioli <= 131, name="max_fat_milkshakes_ravioli")
m.addConstr(6*milkshakes + sashimi <= 139, name="max_fat_milkshakes_sashimi")
m.addConstr(6*milkshakes + 9*ravioli + sashimi <= 139, name="max_fat_all")

# Carbohydrate constraints
m.addConstr(9*milkshakes + 25*sashimi >= 122, name="carb_milkshakes_sashimi")
m.addConstr(23*ravioli + 25*sashimi <= 286, name="max_carb_ravioli_sashimi")
m.addConstr(9*milkshakes + 25*sashimi <= 384, name="max_carb_milkshakes_sashimi")
m.addConstr(9*milkshakes + 23*ravioli <= 227, name="max_carb_milkshakes_ravioli")
m.addConstr(9*milkshakes + 23*ravioli + 25*sashimi <= 227, name="max_carb_all")

# Optimize
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
