
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    milkshakes = model.addVar(name="milkshakes", vtype=gurobi.GRB.INTEGER)
    ravioli = model.addVar(name="ravioli", vtype=gurobi.GRB.INTEGER)
    sashimi = model.addVar(name="sashimi", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4.36 * milkshakes + 8.29 * ravioli + 5.64 * sashimi, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * milkshakes + 9 * ravioli >= 20, name="fat_milkshakes_ravioli")
    model.addConstr(9 * ravioli + sashimi >= 38, name="fat_ravioli_sashimi")
    model.addConstr(6 * milkshakes + sashimi >= 24, name="fat_milkshakes_sashimi")
    model.addConstr(6 * milkshakes + 9 * ravioli + sashimi >= 50, name="total_fat")
    model.addConstr(9 * milkshakes + 25 * sashimi >= 122, name="carbohydrates_milkshakes_sashimi")
    model.addConstr(6 * milkshakes + 9 * ravioli <= 131, name="fat_milkshakes_ravioli_upper")
    model.addConstr(6 * milkshakes + sashimi <= 139, name="fat_milkshakes_sashimi_upper")
    model.addConstr(6 * milkshakes + 9 * ravioli + sashimi <= 139, name="total_fat_upper")
    model.addConstr(23 * ravioli + 25 * sashimi <= 286, name="carbohydrates_ravioli_sashimi_upper")
    model.addConstr(9 * milkshakes + 25 * sashimi <= 384, name="carbohydrates_milkshakes_sashimi_upper")
    model.addConstr(9 * milkshakes + 23 * ravioli <= 227, name="carbohydrates_milkshakes_ravioli_upper")
    model.addConstr(9 * milkshakes + 23 * ravioli + 25 * sashimi <= 227, name="total_carbohydrates_upper")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Ravioli: {ravioli.varValue}")
        print(f"Sashimi: {sashimi.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
