
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
bill_hours = m.addVar(lb=0, name="bill_hours")
peggy_hours = m.addVar(lb=0, name="peggy_hours")
jean_hours = m.addVar(lb=0, name="jean_hours")

# Set objective function
m.setObjective(8 * bill_hours + 9 * peggy_hours + 4 * jean_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(16 * peggy_hours + 5 * jean_hours >= 51, "c1")
m.addConstr(12 * bill_hours + 5 * jean_hours >= 24, "c2")
m.addConstr(20 * bill_hours + 12 * jean_hours >= 34, "c3")
m.addConstr(16 * peggy_hours + 12 * jean_hours >= 96, "c4")
m.addConstr(18 * bill_hours + 2 * jean_hours >= 42, "c5")
m.addConstr(18 * bill_hours + 11 * peggy_hours + 2 * jean_hours >= 37, "c6")
m.addConstr(16 * peggy_hours + 5 * jean_hours <= 118, "c7")
m.addConstr(12 * bill_hours + 5 * jean_hours <= 163, "c8")
m.addConstr(12 * bill_hours + 16 * peggy_hours + 5 * jean_hours <= 125, "c9")
m.addConstr(20 * bill_hours + 12 * jean_hours <= 194, "c10")
m.addConstr(20 * bill_hours + 16 * peggy_hours + 12 * jean_hours <= 194, "c11")
m.addConstr(11 * peggy_hours + 2 * jean_hours <= 134, "c12")
m.addConstr(18 * bill_hours + 11 * peggy_hours <= 64, "c13")
m.addConstr(18 * bill_hours + 11 * peggy_hours + 2 * jean_hours <= 64, "c14")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Bill Hours: %g' % bill_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

