
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
B = m.addVar(lb=0, name="hours_worked_by_Bill")
P = m.addVar(lb=0, name="hours_worked_by_Peggy")
J = m.addVar(lb=0, name="hours_worked_by_Jean")

# Objective function: Maximize 8B + 9P + 4J
m.setObjective(8*B + 9*P + 4*J, GRB.MAXIMIZE)

# Constraints
# Computer competence rating constraints
m.addConstr(P * 16 + J * 5 >= 51, name="Computer_Rating_P_J_min")
m.addConstr(B * 12 + J * 5 >= 24, name="Computer_Rating_B_J_min")
m.addConstr(P * 16 + J * 5 <= 118, name="Computer_Rating_P_J_max")
m.addConstr(B * 12 + J * 5 <= 163, name="Computer_Rating_B_J_max")
m.addConstr(B * 12 + P * 16 + J * 5 <= 125, name="Total_Computer_Rating_max")

# Productivity rating constraints
m.addConstr(B * 20 + J * 12 >= 34, name="Productivity_Rating_B_J_min")
m.addConstr(P * 16 + J * 12 >= 96, name="Productivity_Rating_P_J_min")
m.addConstr(B * 20 + J * 12 <= 194, name="Productivity_Rating_B_J_max")
m.addConstr(B * 20 + P * 16 + J * 12 <= 194, name="Total_Productivity_Rating_max")

# Work quality rating constraints
m.addConstr(B * 18 + J * 2 >= 42, name="Work_Quality_Rating_B_J_min")
m.addConstr(B * 18 + P * 11 + J * 2 >= 37, name="Total_Work_Quality_Rating_min")
m.addConstr(P * 11 + J * 2 <= 134, name="Work_Quality_Rating_P_J_max")
m.addConstr(B * 18 + P * 11 <= 64, name="Work_Quality_Rating_B_P_max")
m.addConstr(B * 18 + P * 11 + J * 2 <= 64, name="Total_Work_Quality_Rating_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution: B={B.x}, P={P.x}, J={J.x}")
else:
    print("No optimal solution found.")
