
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bill", lb=0)
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x2 = m.addVar(name="hours_worked_by_Jean", lb=0)

# Define the objective function
m.setObjective(8*x0 + 9*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x0 <= 186)
m.addConstr(20*x0 <= 296)
m.addConstr(18*x0 <= 160)
m.addConstr(16*x1 <= 186)
m.addConstr(16*x1 <= 296)
m.addConstr(11*x1 <= 160)
m.addConstr(5*x2 <= 186)
m.addConstr(12*x2 <= 296)
m.addConstr(2*x2 <= 160)
m.addConstr(16*x1 + 5*x2 >= 51)
m.addConstr(12*x0 + 5*x2 >= 24)
m.addConstr(20*x0 + 12*x2 >= 34)
m.addConstr(16*x1 + 12*x2 >= 96)
m.addConstr(18*x0 + 2*x2 >= 42)
m.addConstr(18*x0 + 11*x1 + 2*x2 >= 37)
m.addConstr(16*x1 + 5*x2 <= 118)
m.addConstr(12*x0 + 5*x2 <= 163)
m.addConstr(12*x0 + 16*x1 + 5*x2 <= 125)
m.addConstr(20*x0 + 12*x2 <= 194)
m.addConstr(20*x0 + 16*x1 + 12*x2 <= 194)
m.addConstr(11*x1 + 2*x2 <= 134)
m.addConstr(18*x0 + 11*x1 <= 64)
m.addConstr(18*x0 + 11*x1 + 2*x2 <= 64)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Jean: ", x2.varValue)
else:
    print("The problem is infeasible")
