
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
bill_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bill_Hours")
bobby_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="Bobby_Hours")
peggy_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="Peggy_Hours")
george_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="George_Hours")

# Set objective function
model.setObjective(2.56 * bill_hours + 7.44 * bobby_hours + 1.16 * peggy_hours + 8.8 * george_hours, GRB.MINIMIZE)

# Add constraints based on provided data
org_score = {'Bill': 14, 'Bobby': 13, 'Peggy': 17, 'George': 15}
dollar_cost = {'Bill': 9, 'Bobby': 5, 'Peggy': 10, 'George': 14}
quit_index = {'Bill': 7, 'Bobby': 1, 'Peggy': 2, 'George': 10}
work_quality = {'Bill': 5, 'Bobby': 6, 'Peggy': 13, 'George': 9}

model.addConstr(peggy_hours * org_score['Peggy'] + george_hours * org_score['George'] >= 12)
model.addConstr(bill_hours * org_score['Bill'] + bobby_hours * org_score['Bobby'] + peggy_hours * org_score['Peggy'] >= 14)
model.addConstr(bobby_hours * org_score['Bobby'] + peggy_hours * org_score['Peggy'] + george_hours * org_score['George'] >= 14)
model.addConstr(bill_hours * org_score['Bill'] + peggy_hours * org_score['Peggy'] + george_hours * org_score['George'] >= 14)
model.addConstr(bill_hours * org_score['Bill'] + bobby_hours * org_score['Bobby'] + george_hours * org_score['George'] >= 14)

model.addConstr(bill_hours * org_score['Bill'] + bobby_hours * org_score['Bobby'] + peggy_hours * org_score['Peggy'] >= 18)
model.addConstr(bobby_hours * org_score['Bobby'] + peggy_hours * org_score['Peggy'] + george_hours * org_score['George'] >= 18)
model.addConstr(bill_hours * org_score['Bill'] + peggy_hours * org_score['Peggy'] + george_hours * org_score['George'] >= 18)
model.addConstr(bill_hours * org_score['Bill'] + bobby_hours * org_score['Bobby'] + george_hours * org_score['George'] >= 18)

# ... (Similarly add all other constraints) ...

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)
