
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Supplement Cost")

# Create variables
iron = model.addVar(nonnegative=True, name="iron")
b9 = model.addVar(nonnegative=True, name="b9")

# Set objective function
model.setObjective(6.68 * iron + 7.55 * b9, GRB.MINIMIZE)

# Add constraints
model.addConstr(0.4 * iron + 0.14 * b9 >= 47, "cardio_support_min")
model.addConstr(0.4 * iron + 0.14 * b9 <= 104, "cardio_support_max") # Corrected upper bound
model.addConstr(-3 * iron + 4 * b9 >= 0, "iron_b9_ratio")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
    model.computeIIS()  # Compute Irreducible Inconsistent Subsystem
    model.write("infeasible_model.ilp") # Write the IIS to a file for analysis
else:
    # Print results if a feasible solution is found
    print(f"Optimal objective value: {model.objVal}")
    print(f"Milligrams of iron: {iron.x}")
    print(f"Milligrams of vitamin B9: {b9.x}")

