
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
iron_mg = m.addVar(lb=0, name="milligrams_of_iron", vtype=GRB.CONTINUOUS)
vit_b9_mg = m.addVar(lb=0, name="milligrams_of_vitamin_B9", vtype=GRB.CONTINUOUS)

# Objective function
m.setObjective(6.68 * iron_mg + 7.55 * vit_b9_mg, GRB.MINIMIZE)

# Constraints
m.addConstr(0.4 * iron_mg + 0.14 * vit_b9_mg >= 47, name="min_cardio_support")
m.addConstr(-3 * iron_mg + 4 * vit_b9_mg >= 0, name="iron_vit_b9_ratio")
m.addConstr(0.4 * iron_mg + 0.14 * vit_b9_mg <= 104, name="max_cardio_support")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of Iron: {iron_mg.X}")
    print(f"Milligrams of Vitamin B9: {vit_b9_mg.X}")
    print(f"Objective Function Value: {m.ObjVal}")
else:
    print("No optimal solution found. Model status:", m.status)
