
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define variables
milligrams_of_iron = model.addVar(name="milligrams_of_iron", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
milligrams_of_vitamin_B9 = model.addVar(name="milligrams_of_vitamin_B9", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
model.setObjective(6.68 * milligrams_of_iron + 7.55 * milligrams_of_vitamin_B9, gurobi.GRB.MINIMIZE)

# Constraints
r0_x0 = 0.4
r0_x1 = 0.14
model.addConstr(r0_x0 * milligrams_of_iron + r0_x1 * milligrams_of_vitamin_B9 >= 47, name="cardiovascular_support_index_min")
model.addConstr(r0_x0 * milligrams_of_iron + r0_x1 * milligrams_of_vitamin_B9 <= 104, name="cardiovascular_support_index_max")
model.addConstr(-3 * milligrams_of_iron + 4 * milligrams_of_vitamin_B9 >= 0, name="linear_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of iron: {milligrams_of_iron.varValue}")
    print(f"Milligrams of vitamin B9: {milligrams_of_vitamin_B9.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
