
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
instant_ramen = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="instant_ramen")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")

# Set objective function
m.setObjective(3.79 * bananas + 6.29 * rotisserie_chickens + 3.04 * instant_ramen + 4.52 * apples, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * bananas + 10 * apples >= 120, "c1")
m.addConstr(14 * rotisserie_chickens + 22 * apples >= 63, "c2")
m.addConstr(4 * bananas + 14 * rotisserie_chickens >= 47, "c3")
m.addConstr(14 * rotisserie_chickens + 9 * instant_ramen >= 50, "c4")
m.addConstr(6 * bananas + 16 * apples <= 265, "c5")
m.addConstr(20 * rotisserie_chickens + 16 * apples <= 291, "c6")
m.addConstr(6 * bananas + 20 * rotisserie_chickens + 23 * instant_ramen + 16 * apples <= 291, "c7")
m.addConstr(7 * bananas + 10 * apples <= 462, "c8")
m.addConstr(5 * rotisserie_chickens + 11 * instant_ramen <= 130, "c9")
m.addConstr(5 * rotisserie_chickens + 10 * apples <= 199, "c10")
m.addConstr(7 * bananas + 5 * rotisserie_chickens <= 463, "c11")
m.addConstr(7 * bananas + 5 * rotisserie_chickens + 11 * instant_ramen + 10 * apples <= 463, "c12")
m.addConstr(14 * rotisserie_chickens + 22 * apples <= 430, "c13")
m.addConstr(4 * bananas + 9 * instant_ramen <= 213, "c14")
m.addConstr(4 * bananas + 14 * rotisserie_chickens + 9 * instant_ramen + 22 * apples <= 213, "c15")
m.addConstr(21 * bananas + 21 * apples <= 74, "c16")
m.addConstr(21 * bananas + 16 * rotisserie_chickens <= 132, "c17")
m.addConstr(16 * rotisserie_chickens + 21 * apples <= 90, "c18")
m.addConstr(21 * bananas + 21 * instant_ramen <= 99, "c19")
m.addConstr(16 * rotisserie_chickens + 21 * instant_ramen + 21 * apples <= 113, "c20")
m.addConstr(21 * bananas + 16 * rotisserie_chickens + 21 * apples <= 177, "c21")
m.addConstr(21 * bananas + 16 * rotisserie_chickens + 21 * instant_ramen + 21 * apples <= 177, "c22")


# Resource Constraints
m.addConstr(6 * bananas + 20 * rotisserie_chickens + 23 * instant_ramen + 16 * apples <= 339, "protein_constraint")
m.addConstr(7 * bananas + 5 * rotisserie_chickens + 11 * instant_ramen + 10 * apples <= 491, "umami_constraint")
m.addConstr(4 * bananas + 14 * rotisserie_chickens + 9 * instant_ramen + 22 * apples <= 473, "sourness_constraint")
m.addConstr(21 * bananas + 16 * rotisserie_chickens + 21 * instant_ramen + 21 * apples <= 185, "iron_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

