
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
bananas = m.addVar(name="bananas", lb=0)  # No lower bound, can be negative, but we assume non-negative
rotisserie_chickens = m.addVar(name="rotisserie_chickens", lb=0)
bowls_of_instant_ramen = m.addVar(name="bowls_of_instant_ramen", lb=0)
apples = m.addVar(name="apples", lb=0)

# Define the objective function
m.setObjective(3.79 * bananas + 6.29 * rotisserie_chickens + 3.04 * bowls_of_instant_ramen + 4.52 * apples, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * bananas + 10 * apples >= 120)  # umami index from bananas and apples
m.addConstr(14 * rotisserie_chickens + 22 * apples >= 63)  # sourness index from rotisserie chickens and apples
m.addConstr(4 * bananas + 14 * rotisserie_chickens >= 47)  # sourness index from bananas and rotisserie chickens
m.addConstr(14 * rotisserie_chickens + 9 * bowls_of_instant_ramen >= 50)  # sourness index from rotisserie chickens and bowls of instant ramen
m.addConstr(6 * bananas + 16 * apples <= 265)  # protein from bananas and apples
m.addConstr(20 * rotisserie_chickens + 16 * apples <= 291)  # protein from rotisserie chickens and apples
m.addConstr(6 * bananas + 20 * rotisserie_chickens + 23 * bowls_of_instant_ramen + 16 * apples <= 291)  # total protein
m.addConstr(7 * bananas + 10 * apples <= 462)  # umami index from bananas and apples
m.addConstr(5 * rotisserie_chickens + 11 * bowls_of_instant_ramen <= 130)  # umami index from rotisserie chickens and bowls of instant ramen
m.addConstr(5 * rotisserie_chickens + 10 * apples <= 199)  # umami index from rotisserie chickens and apples
m.addConstr(7 * bananas + 5 * rotisserie_chickens <= 463)  # umami index from bananas and rotisserie chickens
m.addConstr(7 * bananas + 5 * rotisserie_chickens + 11 * bowls_of_instant_ramen + 10 * apples <= 463)  # total umami index
m.addConstr(14 * rotisserie_chickens + 22 * apples <= 430)  # sourness index from rotisserie chickens and apples
m.addConstr(4 * bananas + 9 * bowls_of_instant_ramen <= 213)  # sourness index from bananas and bowls of instant ramen
m.addConstr(4 * bananas + 14 * rotisserie_chickens + 9 * bowls_of_instant_ramen + 22 * apples <= 213)  # total sourness index
m.addConstr(21 * bananas + 21 * apples <= 74)  # iron from bananas and apples
m.addConstr(21 * bananas + 16 * rotisserie_chickens <= 132)  # iron from bananas and rotisserie chickens
m.addConstr(16 * rotisserie_chickens + 21 * apples <= 90)  # iron from rotisserie chickens and apples
m.addConstr(21 * bananas + 21 * bowls_of_instant_ramen <= 99)  # iron from bananas and bowls of instant ramen
m.addConstr(16 * rotisserie_chickens + 21 * bowls_of_instant_ramen + 21 * apples <= 113)  # iron from rotisserie chickens, bowls of instant ramen, and apples
m.addConstr(21 * bananas + 16 * rotisserie_chickens + 21 * apples <= 177)  # iron from bananas, rotisserie chickens, and apples
m.addConstr(21 * bananas + 16 * rotisserie_chickens + 21 * bowls_of_instant_ramen + 21 * apples <= 177)  # total iron

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Bananas: ", bananas.varValue)
    print("Rotisserie Chickens: ", rotisserie_chickens.varValue)
    print("Bowls of Instant Ramen: ", bowls_of_instant_ramen.varValue)
    print("Apples: ", apples.varValue)
else:
    print("The model is infeasible")
