
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
napkins = m.addVar(vtype=GRB.INTEGER, name="napkins")
lightbulbs = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")
cookies = m.addVar(vtype=GRB.INTEGER, name="cookies")
paper_towels = m.addVar(vtype=GRB.INTEGER, name="paper_towels")
milk = m.addVar(vtype=GRB.INTEGER, name="milk")

# Set objective function
m.setObjective(4*napkins**2 + 7*napkins*lightbulbs + 2*napkins*cookies + 4*napkins*paper_towels + 6*napkins*milk + 3*lightbulbs**2 + 7*lightbulbs*cookies + 9*lightbulbs*paper_towels + 5*lightbulbs*milk + 1*cookies**2 + 7*cookies*paper_towels + 5*paper_towels**2 + 9*paper_towels*milk + 6*milk**2 + 2*napkins + 2*lightbulbs + 7*cookies + 9*paper_towels + 2*milk, GRB.MINIMIZE)

# Add constraints
m.addConstr(9*napkins + 3*lightbulbs + 11*cookies + 4*paper_towels + 8*milk <= 121, "storage_space") # Total storage space
m.addConstr(11*napkins + 11*lightbulbs + 2*cookies + 14*paper_towels + 2*milk <= 154, "weight") # Total weight

m.addConstr(4*paper_towels + 8*milk >= 13, "c1")
m.addConstr(9*napkins + 11*cookies >= 21, "c2")
m.addConstr(9*napkins + 3*lightbulbs >= 23, "c3")
m.addConstr(3*lightbulbs + 4*paper_towels >= 11, "c4")
m.addConstr(3*lightbulbs**2 + 8*milk**2 >= 23, "c5") # Note: squared variables
m.addConstr(9*napkins + 4*paper_towels >= 15, "c6")
m.addConstr(9*napkins + 3*lightbulbs + 4*paper_towels >= 12, "c7")
m.addConstr(9*napkins + 3*lightbulbs + 11*cookies + 4*paper_towels + 8*milk >= 12, "c8")

m.addConstr(11*napkins**2 + 11*lightbulbs**2 >= 30, "w1") # Note: squared variables
m.addConstr(11*napkins**2 + 2*milk**2 >= 14, "w2") # Note: squared variables
m.addConstr(11*napkins**2 + 2*cookies**2 >= 16, "w3") # Note: squared variables
m.addConstr(11*lightbulbs + 2*milk >= 16, "w4")
m.addConstr(11*lightbulbs + 14*paper_towels >= 23, "w5")
m.addConstr(2*cookies + 2*milk >= 27, "w6")
m.addConstr(2*cookies**2 + 14*paper_towels**2 >= 11, "w7") # Note: squared variables
m.addConstr(11*napkins + 14*paper_towels >= 23, "w8")
m.addConstr(11*napkins**2 + 11*lightbulbs**2 + 2*milk**2 >= 27, "w9") # Note: squared variables
m.addConstr(2*cookies + 14*paper_towels + 2*milk >= 27, "w10")
m.addConstr(11*napkins + 11*lightbulbs + 2*milk >= 22, "w11")
m.addConstr(2*cookies + 14*paper_towels + 2*milk >= 22, "w12")
m.addConstr(11*napkins + 11*lightbulbs + 2*cookies + 14*paper_towels + 2*milk >= 22, "w13")


m.addConstr(-1*lightbulbs + 4*milk >= 0, "c9")
m.addConstr(-8*cookies + 8*milk >= 0, "c10")
m.addConstr(3*lightbulbs + 11*cookies <= 121, "c11")
m.addConstr(9*napkins**2 + 11*cookies**2 <= 37, "c12") # Note: squared variables


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

