
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="packs of napkins", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="cookies", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="paper towel rolls", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="cartons of milk", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(4*x0**2 + 7*x0*x1 + 2*x0*x2 + 4*x0*x3 + 6*x0*x4 + 
               3*x1**2 + 7*x1*x2 + 9*x1*x3 + 5*x1*x4 + x2**2 + 
               7*x2*x3 + 5*x3**2 + 9*x3*x4 + 6*x4**2 + 2*x0 + 
               2*x1 + 7*x2 + 9*x3 + 2*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(9*x0 <= 121)
m.addConstr(11*x0 <= 154)
m.addConstr(3*x1 <= 121)
m.addConstr(11*x1 <= 154)
m.addConstr(11*x2 <= 121)
m.addConstr(2*x2 <= 154)
m.addConstr(4*x3 <= 121)
m.addConstr(14*x3 <= 154)
m.addConstr(8*x4 <= 121)
m.addConstr(2*x4 <= 154)
m.addConstr(4*x3 + 8*x4 >= 13)
m.addConstr(9*x0 + 11*x2 >= 21)
m.addConstr(9*x0 + 3*x1 >= 23)
m.addConstr(3*x1 + 4*x3 >= 11)
m.addConstr(3*x1**2 + 2*x4**2 >= 23)
m.addConstr(9*x0 + 4*x3 >= 15)
m.addConstr(9*x0 + 3*x1 + 4*x3 >= 12)
m.addConstr(9*x0 + 3*x1 + 11*x2 + 4*x3 + 8*x4 >= 12)
m.addConstr(11*x0**2 + 11*x1**2 >= 30)
m.addConstr(11*x0**2 + 2*x4**2 >= 14)
m.addConstr(11*x0**2 + 2*x2**2 >= 16)
m.addConstr(11*x1 + 2*x4 >= 16)
m.addConstr(11*x1 + 14*x3 >= 23)
m.addConstr(2*x2 + 2*x4 >= 27)
m.addConstr(2*x2**2 + 5*x3**2 >= 11)
m.addConstr(11*x0 + 14*x3 >= 23)
m.addConstr(11*x0**2 + 11*x1**2 + 2*x4**2 >= 27)
m.addConstr(2*x2 + 14*x3 + 2*x4 >= 27)
m.addConstr(11*x0 + 11*x1 + 2*x4 >= 22)
m.addConstr(2*x2 + 14*x3 + 2*x4 >= 22)
m.addConstr(11*x0 + 11*x1 + 2*x2 + 14*x3 + 2*x4 >= 22)
m.addConstr(-x1 + 4*x4 >= 0)
m.addConstr(-8*x2 + 8*x4 >= 0)
m.addConstr(3*x1 + 11*x2 <= 121)
m.addConstr(9*x0**2 + 11*x2**2 <= 37)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("packs of napkins: ", x0.varValue)
    print("lightbulbs: ", x1.varValue)
    print("cookies: ", x2.varValue)
    print("paper towel rolls: ", x3.varValue)
    print("cartons of milk: ", x4.varValue)
else:
    print("No solution found")
