
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
manila_envelopes = model.addVar(vtype=GRB.INTEGER, name="manila_envelopes")
red_highlighters = model.addVar(vtype=GRB.INTEGER, name="red_highlighters")
paper_clips = model.addVar(vtype=GRB.INTEGER, name="paper_clips")

# Set objective function
model.setObjective(9 * manila_envelopes + 8 * red_highlighters + 1 * paper_clips, GRB.MINIMIZE)

# Add constraints
model.addConstr(9.78 * manila_envelopes + 12.61 * paper_clips >= 40, "c1")
model.addConstr(9.78 * manila_envelopes + 4.69 * red_highlighters >= 62, "c2")
model.addConstr(9.78 * manila_envelopes + 4.69 * red_highlighters + 12.61 * paper_clips >= 62, "c3")
model.addConstr(2 * manila_envelopes - 7 * red_highlighters >= 0, "c4")


# Add sustainability constraint (from the context)
model.addConstr(9.78 * manila_envelopes + 4.69 * red_highlighters + 12.61 * paper_clips <= 287, "sustainability")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('manila_envelopes:', manila_envelopes.x)
    print('red_highlighters:', red_highlighters.x)
    print('paper_clips:', paper_clips.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

