
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="manila_envelopes")
x1 = m.addVar(vtype=GRB.INTEGER, name="red_highlighters")
x2 = m.addVar(vtype=GRB.INTEGER, name="paper_clips")

# Set the objective function
m.setObjective(9*x0 + 8*x1 + x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(9.78*x0 + 12.61*x2 >= 40, name="sustainability_score_min_1")
m.addConstr(9.78*x0 + 4.69*x1 >= 62, name="sustainability_score_min_2")
m.addConstr(9.78*x0 + 4.69*x1 + 12.61*x2 >= 62, name="total_sustainability_score_min")
m.addConstr(2*x0 - 7*x1 >= 0, name="envelopes_highlighters_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Manila Envelopes:", x0.x)
    print("Red Highlighters:", x1.x)
    print("Paper Clips:", x2.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)
