
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="manila_envelopes", vtype=gp.GRB.INTEGER)  # Integer
x1 = m.addVar(name="red_highlighters", vtype=gp.GRB.INTEGER)  # Integer
x2 = m.addVar(name="paper_clips", vtype=gp.GRB.INTEGER)  # Integer

# Define the objective function
m.setObjective(9 * x0 + 8 * x1 + x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(9.78 * x0 + 12.61 * x2 >= 40, name="sustainability_manila_paper")
m.addConstr(9.78 * x0 + 4.69 * x1 >= 62, name="sustainability_manila_highlighter")
m.addConstr(9.78 * x0 + 4.69 * x1 + 12.61 * x2 >= 62, name="sustainability_total")
m.addConstr(2 * x0 - 7 * x1 >= 0, name="manila_highlighter_constraint")

# Set the sustainability score upper bound (not directly mentioned as a constraint but as an attribute)
# This is not a constraint but an attribute, so we don't add it directly to the model

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Manila Envelopes: ", x0.varValue)
    print("Red Highlighters: ", x1.varValue)
    print("Paper Clips: ", x2.varValue)
else:
    print("The model is infeasible")
