
import gurobi as gp

# Create a new model
model = gp.Model("vitamin_optimization")

# Define the variables
x0 = model.addVar(lb=0, name="milligrams_of_vitamin_B5")  
x1 = model.addVar(lb=0, type=gp.GRB.INTEGER, name="milligrams_of_vitamin_B3")
x2 = model.addVar(lb=0, type=gp.GRB.INTEGER, name="milligrams_of_vitamin_B2")

# Define the objective function
model.setObjective(6 * x0 + 3 * x1 + 5 * x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.06 * x0 <= 50)
model.addConstr(1.05 * x0 <= 66)
model.addConstr(8.57 * x0 <= 126)
model.addConstr(8.56 * x1 <= 50)
model.addConstr(7.92 * x1 <= 66)
model.addConstr(7.38 * x1 <= 126)
model.addConstr(0.26 * x2 <= 50)
model.addConstr(4.16 * x2 <= 66)
model.addConstr(6.67 * x2 <= 126)
model.addConstr(0.06 * x0 + 0.26 * x2 >= 11)
model.addConstr(0.06 * x0 + 8.56 * x1 + 0.26 * x2 >= 15)
model.addConstr(1.05 * x0 + 7.92 * x1 >= 11)
model.addConstr(1.05 * x0 + 7.92 * x1 + 4.16 * x2 >= 12)
model.addConstr(8.57 * x0 + 7.38 * x1 >= 25)
model.addConstr(8.57 * x0 + 7.38 * x1 + 6.67 * x2 >= 25)
model.addConstr(2 * x0 - 9 * x2 >= 0)
model.addConstr(8.56 * x1 + 0.26 * x2 <= 43)
model.addConstr(0.06 * x0 + 0.26 * x2 <= 19)
model.addConstr(1.05 * x0 + 7.92 * x1 + 4.16 * x2 <= 58)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B5: {x0.varValue}")
    print(f"Milligrams of vitamin B3: {x1.varValue}")
    print(f"Milligrams of vitamin B2: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
