
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean_hours = m.addVar(lb=0, name="jean_hours")
peggy_hours = m.addVar(lb=0, name="peggy_hours")
george_hours = m.addVar(lb=0, name="george_hours")
mary_hours = m.addVar(lb=0, name="mary_hours")

# Set objective function
m.setObjective(6.0 * jean_hours**2 + 6.79 * jean_hours * peggy_hours + 7.63 * jean_hours * george_hours + 5.35 * jean_hours * mary_hours + 3.06 * peggy_hours**2 + 2.94 * peggy_hours * george_hours + 3.06 * peggy_hours * mary_hours + 8.23 * george_hours**2 + 8.03 * george_hours * mary_hours + 4.6 * mary_hours**2 + 5.47 * jean_hours + 6.14 * peggy_hours + 1.27 * george_hours + 8.79 * mary_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.15 * peggy_hours**2 + 0.69 * mary_hours**2 >= 59)
m.addConstr(0.15 * peggy_hours + 0.24 * george_hours >= 67)
m.addConstr(0.11 * jean_hours + 0.69 * mary_hours >= 34)
m.addConstr(0.11 * jean_hours**2 + 0.24 * george_hours**2 >= 45)
m.addConstr(0.24 * george_hours**2 + 0.69 * mary_hours**2 >= 38)
m.addConstr(0.11 * jean_hours + 0.15 * peggy_hours + 0.69 * mary_hours >= 63)
m.addConstr(0.15 * peggy_hours + 0.24 * george_hours + 0.69 * mary_hours >= 63)
m.addConstr(0.11 * jean_hours + 0.24 * george_hours + 0.69 * mary_hours >= 63)
m.addConstr(0.11 * jean_hours**2 + 0.15 * peggy_hours**2 + 0.24 * george_hours**2 >= 63)
m.addConstr(0.11 * jean_hours**2 + 0.15 * peggy_hours**2 + 0.69 * mary_hours**2 >= 47)
m.addConstr(0.15 * peggy_hours + 0.24 * george_hours + 0.69 * mary_hours >= 47)
m.addConstr(0.11 * jean_hours + 0.24 * george_hours + 0.69 * mary_hours >= 47)
m.addConstr(0.11 * jean_hours**2 + 0.15 * peggy_hours**2 + 0.24 * george_hours**2 >= 47)
m.addConstr(0.11 * jean_hours + 0.15 * peggy_hours + 0.69 * mary_hours >= 38)
m.addConstr(0.15 * peggy_hours + 0.24 * george_hours + 0.69 * mary_hours >= 38)
m.addConstr(0.11 * jean_hours + 0.24 * george_hours + 0.69 * mary_hours >= 38)
m.addConstr(0.11 * jean_hours**2 + 0.15 * peggy_hours**2 + 0.24 * george_hours**2 >= 38)
m.addConstr(0.11 * jean_hours + 0.15 * peggy_hours + 0.69 * mary_hours >= 43)
m.addConstr(0.15 * peggy_hours + 0.24 * george_hours + 0.69 * mary_hours >= 43)
m.addConstr(0.11 * jean_hours + 0.24 * george_hours + 0.69 * mary_hours >= 43)
m.addConstr(0.11 * jean_hours**2 + 0.15 * peggy_hours**2 + 0.24 * george_hours**2 >= 43)
m.addConstr(0.11 * jean_hours + 0.15 * peggy_hours + 0.24 * george_hours + 0.69 * mary_hours >= 43)

m.addConstr(0.25 * jean_hours**2 + 0.79 * peggy_hours**2 >= 36)
m.addConstr(0.25 * jean_hours**2 + 0.79 * peggy_hours**2 + 0.72 * george_hours**2 >= 59)
m.addConstr(0.25 * jean_hours + 0.79 * peggy_hours + 0.72 * george_hours + 0.27 * mary_hours >= 59)

m.addConstr(0.26 * george_hours + 0.25 * mary_hours >= 67)
m.addConstr(0.85 * jean_hours**2 + 0.25 * mary_hours**2 >= 74)
m.addConstr(0.85 * jean_hours + 0.07 * peggy_hours >= 76)
m.addConstr(0.85 * jean_hours + 0.26 * george_hours >= 71)
m.addConstr(0.07 * peggy_hours + 0.26 * george_hours >= 44)
m.addConstr(0.07 * peggy_hours + 0.26 * george_hours + 0.25 * mary_hours >= 75)
m.addConstr(0.85 * jean_hours + 0.07 * peggy_hours + 0.26 * george_hours >= 75)
m.addConstr(0.07 * peggy_hours + 0.26 * george_hours + 0.25 * mary_hours >= 76)
m.addConstr(0.85 * jean_hours**2 + 0.07 * peggy_hours**2 + 0.26 * george_hours**2 >= 76)
m.addConstr(0.85 * jean_hours + 0.07 * peggy_hours + 0.26 * george_hours + 0.25 * mary_hours >= 76)


m.addConstr(0.69 * jean_hours + 0.18 * mary_hours >= 24)
m.addConstr(0.6 * george_hours**2 + 0.18 * mary_hours**2 >= 20)
m.addConstr(0.69 * jean_hours + 0.6 * george_hours >= 45)
m.addConstr(0.03 * peggy_hours**2 + 0.18 * mary_hours**2 >= 21)
m.addConstr(0.69 * jean_hours + 0.03 * peggy_hours >= 25)
m.addConstr(0.69 * jean_hours + 0.03 * peggy_hours + 0.6 * george_hours >= 41)
m.addConstr(0.69 * jean_hours + 0.6 * george_hours + 0.18 * mary_hours >= 41)
m.addConstr(0.03 * peggy_hours**2 + 0.6 * george_hours**2 + 0.18 * mary_hours**2 >= 41)
m.addConstr(0.69 * jean_hours + 0.03 * peggy_hours + 0.6 * george_hours >= 41)
m.addConstr(0.69 * jean_hours**2 + 0.6 * george_hours**2 + 0.18 * mary_hours**2 >= 41)
m.addConstr(0.03 * peggy_hours**2 + 0.6 * george_hours**2 + 0.18 * mary_hours**2 >= 41)
m.addConstr(0.69 * jean_hours**2 + 0.03 * peggy_hours**2 + 0.6 * george_hours**2 >= 47)
m.addConstr(0.69 * jean_hours**2 + 0.6 * george_hours**2 + 0.18 * mary_hours**2 >= 47)
m.addConstr(0.03 * peggy_hours**2 + 0.6 * george_hours**2 + 0.18 * mary_hours**2 >= 47)
m.addConstr(0.69 * jean_hours + 0.03 * peggy_hours + 0.6 * george_hours + 0.18 * mary_hours >= 47)


m.addConstr(9 * peggy_hours - 8 * mary_hours >= 0)
m.addConstr(-8 * george_hours + 3 * mary_hours >= 0)
m.addConstr(0.79 * peggy_hours**2 + 0.27 * mary_hours**2 <= 162)
m.addConstr(0.25 * jean_hours + 0.79 * peggy_hours + 0.27 * mary_hours <= 106)
m.addConstr(0.85 * jean_hours + 0.07 * peggy_hours + 0.25 * mary_hours <= 169)
m.addConstr(0.85 * jean_hours**2 + 0.07 * peggy_hours**2 + 0.26 * george_hours**2 <= 308)
m.addConstr(0.07 * peggy_hours + 0.26 * george_hours + 0.25 * mary_hours <= 208)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
