
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
J = m.addVar(name="hours_worked_by_Jean", lb=0)
P = m.addVar(name="hours_worked_by_Peggy", lb=0)
G = m.addVar(name="hours_worked_by_George", lb=0)
M = m.addVar(name="hours_worked_by_Mary", lb=0)

# Define the objective function
m.setObjective(6.0*J**2 + 6.79*J*P + 7.63*J*G + 5.35*J*M + 
               3.06*P**2 + 2.94*P*G + 3.06*P*M + 
               8.23*G**2 + 8.03*G*M + 4.6*M**2 + 
               5.47*J + 6.14*P + 1.27*G + 8.79*M, gp.GRB.MINIMIZE)

# Individual attribute constraints
m.addConstraint(J >= 0)
m.addConstraint(P >= 0)
m.addConstraint(G >= 0)
m.addConstraint(M >= 0)

# Productivity rating constraints
productivity_ratings = {
    'Jean': 0.11,
    'Peggy': 0.15,
    'George': 0.24,
    'Mary': 0.69,
}

# Likelihood to quit index constraints
likelihood_to_quit_indices = {
    'Jean': 0.25,
    'Peggy': 0.79,
    'George': 0.72,
    'Mary': 0.27,
}

# Computer competence rating constraints
computer_competence_ratings = {
    'Jean': 0.85,
    'Peggy': 0.07,
    'George': 0.26,
    'Mary': 0.25,
}

# Organization score constraints
organization_scores = {
    'Jean': 0.69,
    'Peggy': 0.03,
    'George': 0.6,
    'Mary': 0.18,
}

# Combined productivity rating constraints
m.addConstraint(0.15*P**2 + 0.69*M**2 >= 59)
m.addConstraint(0.15*P + 0.24*G >= 67)
m.addConstraint(0.11*J + 0.69*M >= 34)
m.addConstraint(0.11*J**2 + 0.24*G**2 >= 45)
m.addConstraint(0.24*G**2 + 0.25*M**2 >= 38)
m.addConstraint(0.11*J + 0.15*P + 0.69*M >= 63)
m.addConstraint(0.15*P + 0.24*G + 0.25*M >= 63)
m.addConstraint(0.11*J + 0.24*G + 0.69*M >= 63)
m.addConstraint(0.11*J**2 + 0.15*P**2 + 0.24*G**2 >= 63)
m.addConstraint(0.11*J**2 + 0.15*P**2 + 0.25*M**2 >= 47)
m.addConstraint(0.15*P + 0.24*G + 0.25*M >= 47)
m.addConstraint(0.11*J + 0.24*G + 0.69*M >= 47)
m.addConstraint(0.11*J**2 + 0.15*P**2 + 0.24*G**2 >= 47)
m.addConstraint(0.11*J + 0.15*P + 0.69*M >= 38)
m.addConstraint(0.15*P + 0.24*G + 0.25*M >= 38)
m.addConstraint(0.11*J + 0.24*G + 0.69*M >= 38)
m.addConstraint(0.11*J**2 + 0.15*P**2 + 0.24*G**2 >= 38)

# Likelihood to quit index constraints
m.addConstraint(0.25*J**2 + 0.79*P**2 >= 36)
m.addConstraint(0.25*J**2 + 0.79*P**2 + 0.72*G**2 >= 59)
m.addConstraint(0.25*J + 0.79*P + 0.72*G + 0.27*M >= 59)

# Computer competence rating constraints
m.addConstraint(0.26*G + 0.25*M >= 67)
m.addConstraint(0.85*J**2 + 0.25*M**2 >= 74)
m.addConstraint(0.85*J + 0.07*P >= 76)
m.addConstraint(0.85*J + 0.26*G >= 71)
m.addConstraint(0.07*P + 0.26*G >= 44)
m.addConstraint(0.07*P + 0.26*G + 0.25*M >= 75)
m.addConstraint(0.85*J + 0.07*P + 0.26*G >= 75)
m.addConstraint(0.07*P + 0.26*G + 0.25*M >= 76)
m.addConstraint(0.85*J**2 + 0.07*P**2 + 0.26*G**2 >= 76)

# Organization score constraints
m.addConstraint(0.69*J + 0.18*M >= 24)
m.addConstraint(0.6*G**2 + 0.18*M**2 >= 20)
m.addConstraint(0.69*J + 0.6*G >= 45)
m.addConstraint(0.03*P**2 + 0.18*M**2 >= 21)
m.addConstraint(0.69*J + 0.03*P >= 25)
m.addConstraint(0.69*J + 0.03*P + 0.6*G >= 41)
m.addConstraint(0.69*J + 0.6*G + 0.18*M >= 41)

# Other constraints
m.addConstraint(9*P - 8*M >= 0)
m.addConstraint(-8*G + 3*M >= 0)
m.addConstraint(0.79*P**2 + 0.27*M**2 <= 162)
m.addConstraint(0.25*J + 0.79*P + 0.27*M <= 106)
m.addConstraint(0.85*J + 0.07*P + 0.25*M <= 169)
m.addConstraint(0.85*J**2 + 0.07*P**2 + 0.26*G**2 <= 308)
m.addConstraint(0.07*P + 0.26*G + 0.25*M <= 208)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Jean: {J.varValue}")
    print(f"Hours worked by Peggy: {P.varValue}")
    print(f"Hours worked by George: {G.varValue}")
    print(f"Hours worked by Mary: {M.varValue}")
else:
    print("No optimal solution found.")
