
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS, name='kale_salads')
    x1 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name='rotisserie_chickens')
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name='potatoes')
    x3 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name='blueberry_pies')

    # Define objective function
    model.setObjective(3*x0 + 7*x1 + 7*x2 + 5*x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8*x0 + 2*x2 >= 3, name='sourness_kale_potatoes')
    model.addConstr(2*x2 + 6*x3 >= 6, name='sourness_potatoes_pies')
    model.addConstr(8*x1 + 6*x3 >= 8, name='sourness_chickens_pies')
    model.addConstr(8*x0 + 8*x1 >= 10, name='sourness_kale_chickens')
    model.addConstr(8*x0 + 8*x1 + 2*x2 + 6*x3 >= 10, name='total_sourness')

    model.addConstr(7*x0 + 7*x2 >= 10, name='tastiness_kale_potatoes')
    model.addConstr(2*x1 + 2*x3 >= 18, name='tastiness_chickens_pies')
    model.addConstr(2*x1 + 7*x2 >= 9, name='tastiness_chickens_potatoes')
    model.addConstr(7*x0 + 2*x3 >= 15, name='tastiness_kale_pies')
    model.addConstr(7*x0 + 2*x1 + 2*x3 >= 25, name='tastiness_kale_chickens_pies')
    model.addConstr(7*x0 + 2*x1 + 7*x2 + 2*x3 >= 25, name='total_tastiness')

    model.addConstr(2*x0 - x2 >= 0, name='additional_constraint1')
    model.addConstr(10*x1 - 6*x2 >= 0, name='additional_constraint2')

    model.addConstr(8*x0 + 2*x2 <= 21, name='upper_bound_kale_potatoes')
    model.addConstr(8*x0 + 8*x1 <= 12, name='upper_bound_kale_chickens')
    model.addConstr(8*x0 + 8*x1 + 2*x2 <= 12, name='upper_bound_kale_chickens_potatoes')
    model.addConstr(8*x0 + 2*x2 + 6*x3 <= 43, name='upper_bound_total_sourness')
    model.addConstr(2*x1 + 2*x3 <= 90, name='upper_bound_chickens_pies')
    model.addConstr(7*x0 + 2*x1 + 2*x3 <= 47, name='upper_bound_tastiness_kale_chickens_pies')

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Kale Salads: ', x0.varValue)
        print('Rotisserie Chickens: ', x1.varValue)
        print('Potatoes: ', x2.varValue)
        print('Blueberry Pies: ', x3.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
