
from gurobipy import *

# Create a model
m = Model("Work Hours Optimization")

# Define variables for hours worked by each person
Bobby = m.addVar(lb=0, name="Bobby")
Paul = m.addVar(lb=0, name="Paul")
Peggy = m.addVar(lb=0, name="Peggy")
Dale = m.addVar(lb=0, name="Dale")
Mary = m.addVar(lb=0, name="Mary")
George = m.addVar(lb=0, name="George")
Jean = m.addVar(lb=0, name="Jean")
John = m.addVar(lb=0, name="John")
Hank = m.addVar(lb=0, name="Hank")

# Constraints for paperwork index
m.addConstr(Mary <= 458)
m.addConstr(Bobby + Paul <= 394)
m.addConstr(Peggy + Dale <= 236)

# Constraints for organization index (Example constraints)
m.addConstr(Dale + Hank <= 407)
m.addConstr(George + Jean <= 564)
m.addConstr(Jean + Hank <= 387)

# Constraints for likelihood to quit index (Example constraints)
m.addConstr(Bobby + Jean <= 157)
m.addConstr(Bobby + Dale <= 247)
m.addConstr(Paul + Hank <= 235)
m.addConstr(Paul + George <= 206)

# Objective function: Since the problem doesn't specify an objective, we'll minimize the total hours worked
m.setObjective(Bobby + Paul + Peggy + Dale + Mary + George + Jean + John + Hank, GRB.MINIMIZE)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
